<?php

namespace Modules\Banners\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Banners\app\Models\Banners;
use Modules\Mwz\app\Http\Controllers\AdminController;

class BannersController extends AdminController
{
	/**
	 * Function : get list
	 * Dev : Petch
	 * Update Date : 4 March 2025
	 */
	public static function get_list($type, $option = [])
	{
		$data = [];
		$req = Banners::where([['type', $type], ['status', 1]])
			->where(function ($query) use ($option) {
				if (!empty($option['menu_id']))
					$query = $query->where('menu_id', $option['menu_id']);
				else
					$query = $query->whereNull('menu_id');

				if (!empty($option['section']))
					$query = $query->where('section', $option['section']);
			})
			->orderBy($option['column'] ?? 'sequence', $option['dir'] ?? 'ASC')
			->with(['local'])
			->get();

		foreach ($req as $item)
			$data[] = self::card($item);

		return $data;
	}

	/**
	 * Function : card
	 * Dev : Petch
	 * Update Date : 4 March 2025
	 */
	private static function card($resp): array
	{
		$config = config("banners.{$resp->type}");
		$data = [
			'id' => $resp->id,
		];
		foreach ($config['form']['navbar']['translate']['input'] as $key => $input) {
			if (!empty($input['status']))
				$data[$key] = mwz_getTextString($resp->local->{$key} ?? null, $input['type'] == 'texteditor');
		}

		if (!empty($config['form']['sidebar']['setting']['input']['link']['status']))
			$data['url'] = $resp->link ?? null;

		switch ($resp->style) {
			case 1:
				$data['type'] = 'image';
				$data['src']  = check_file($resp->image ?? '', asset('assets/images/banner.png'));
				if (!empty($config['form']['navbar']['banner']['input']['row_1']['moblie']['status']))
					$data['mobile'] = $resp->mobile;

				break;
			case 2:
				$data['type'] = 'youtube';
				$data['src']  = $resp->youtube ?? '';
				$data['cover']  = check_file($resp->image ?? '', asset('assets/images/banner.png'));
				break;
			case 3:
				$data['type'] = 'video';
				$data['src']  = $resp->video ?? '';
				$data['cover']  = asset('modules/frontend/img/logo-2.png');
				break;
		}

		return $data;
	}

	/**
	 * Function : click
	 * Dev : Petch
	 * Update Date : 20 March 2025
	 */
	public static function click(Request $request)
	{
		if (empty($request->get('id')))
			return self::response(['msg' => 'Error'], Response::HTTP_BAD_REQUEST);

		$banner = Banners::find($request->get('id'));
		if (empty($banner))
			return self::response(['msg' => 'Error'], Response::HTTP_BAD_REQUEST);

		$banner->view = !empty($banner->view) ? $banner->view + 1 : 1;
		if ($banner->save())
			return self::response(['msg' => 'Success']);

		return self::response(['msg' => 'Error'], Response::HTTP_INTERNAL_SERVER_ERROR);
	}
}
