<?php

namespace Modules\Banners\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Menu\app\Models\Menu;

class Banners extends Model
{
	use HasFactory;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'type',
		'menu_id',
		'style',
		'image',
		'mobile',
		'youtube',
		'video',
		'link',
		'view',
		'section',
		'sequence',
		'status',
	];
	protected $table = 'banners';
	protected $primaryKey = 'id';

	protected static function boot(): void
	{
		parent::boot();
		static::deleting(function ($model) {
			$model->langs()->delete();
		});
	}

	public function langs()
	{
		return $this->hasMany(BannerTranslate::class, 'banner_id', 'id');
	}

	public function local()
	{
		return $this->hasOne(BannerTranslate::class, 'banner_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
	}

	public function menu()
	{
		return $this->hasOne(Menu::class, 'id', 'menu_id');
	}
}
