<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
	/**
	 * Run the migrations.
	 */
	public function up(): void
	{
		Schema::create('banners', function (Blueprint $table) {
			$table->id();
			$table->tinyText('type')->nullable();
			$table->integer('menu_id')->nullable();
			$table->integer('style')->nullable();
			$table->string('image')->nullable();
			$table->string('mobile')->nullable();
			$table->string('youtube')->nullable();
			$table->string('video')->nullable();
			$table->string('link')->nullable();
			$table->bigInteger('view')->nullable();
			$table->integer('section')->nullable();
			$table->integer('sequence')->nullable();
			$table->boolean('status')->nullable();
			$table->timestamps();
		});

		Schema::create('banners_translate', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('banner_id')->nullable();
			$table->string('lang')->nullable();
			$table->string('name')->nullable();
			$table->longText('desc')->nullable();
			$table->longText('detail')->nullable();
			$table->timestamps();
			$table->foreign('banner_id')->references('id')->on('banners');
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down(): void
	{
		Schema::dropIfExists('banners_translate');
		Schema::dropIfExists('banners');
	}
};
