@php
    $setting = $config['form']['sidebar']['setting']['input'];
    $k_last = array_key_last($setting);
@endphp
<div class="card card-body">
    @foreach ($setting as $k_s => $s)
        @if (!empty($s['status']))
            @php
                $chk_req = !empty($s['validate']);
            @endphp
            <div class="{{ $k_s != $k_last ? 'mb-2' : '' }} {{ $k_s }}">
                @if ($s['type'] == 'checkbox')
                    @php
                        $chk = !empty($data) ? $data->{$k_s} == 1 : true;
                    @endphp
                    <x-form.checkbox name="{{ $k_s }}" label='{{ __("field.{$k_s}") }}' :checked=$chk />
                @elseif ($s['type'] == 'selection')
                    @php
                        $chk_option = !empty($data->{$k_s}) ? $data->{$k_s} : 1;
                    @endphp
                    <x-select2.selection class="select2" id="{{ $k_s }}" name="{{ $k_s }}" label='{{ __("field.{$k_s}") }}' placeholder='{{ __("field.{$k_s}_placeholder") }}' :required=$chk_req>
                        <x-slot:option>
                            @if (!empty($s['options']))
                                @foreach ($s['options'] as $k_o => $o)
                                    <option value="{{ $k_o }}" @if ($chk_option == $k_o) selected @endif>
                                        {{ $o }}
                                    </option>
                                @endforeach
                            @endif
                        </x-slot:option>
                    </x-select2.selection>
                @elseif ($s['type'] == 'select')
                    @php
                        $key = explode('_', $k_s);
                        if (count($key) > 1) {
                            $key = $key[0];
                        }
                        $selected = $data->{$key} ?? null;
                    @endphp
                    <x-select2.select id="{{ $k_s }}" name="{{ $k_s }}" label='{{ __("field.{$k_s}") }}' :required=$chk_req :selected=$selected url="{{ route($s['url']) }}" placeholder='{{ __("field.{$k_s}_placeholder") }}' />
                @elseif ($s['type'] == 'input')
                    <x-form.input name="{{ $k_s }}" type="{{ $s['type'] }}" value="{{ $data->{$k_s} ?? null }}" label='{{ __("field.{$k_s}") }}' placeholder='{{ __("field.{$k_s}_placeholder") }}' :required=$chk_req />
                @endif
            </div>
        @endif
    @endforeach
</div>
