@extends('table.app')

@section('styles')
    <!-- datatable re order .css -->
    <link href="{{ asset('assets/libs/datatable-reorder/rowReorder.dataTables.min.css') }}" rel="stylesheet" />
@endsection

@section('content')
    <!-- table -->
    @includeIf('banners::table.table')
    <!-- table -->

    <!-- filter -->
    @includeIf('banners::table.filter')
    <!-- filter -->
@endsection

@section('scripts')
    <script src="{{ asset('assets/libs/datatable-reorder/dataTables.rowReorder.min.js') }}"></script>

    <script>
        const $_name = '<?= $name ?>';
        const $_type = '<?= $type ?>';
        const $_config = $.parseJSON('<?= json_encode($config) ?>');

        // link action
        const $_link_datatable = '{{ route("admin.{$name}.{$type}.datatable_ajax") }}';
        const $_link_status = '{{ route("admin.{$name}.{$type}.set_status") }}';
        const $_link_delete = '{{ route("admin.{$name}.{$type}.set_delete") }}';
        const $_link_sort = '{{ route("admin.{$name}.{$type}.set_sort") }}';
        const $_link_re_order = '{{ route("admin.{$name}.{$type}.set_re_order") }}';
    </script>

    {{ module_vite('build-banners', 'resources/assets/js/banner.js') }}
@endsection
