<?php

namespace Modules\Contact\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Modules\Contact\app\Models\Branchs;

class BranchController extends Controller
{

    /**
	 * Function : contact branch
	 * Dev : Petch
	 * Update Date : 9 Dec 2024
	 */
	public static function get_list($option = [])
	{
		$data = [];
		$branchs = Branchs::where('status', 1)
			->with(['local'])
			->orderBy($option['column'] ?? 'sequence', $option['dir'] ?? 'ASC')
			->get();

		if (!empty($branchs) && count($branchs)) {
			foreach ($branchs as $b) {
				$data[] = [
					'name' => $b->local->name ?? '',
					'image' => check_file($b->image ?? null, asset('assets/images/3-2.png')),
					'google_map' => mwz_getTextString($b->google_map ?? ''),
					'office' => $b->local->office ?? '',
					'email' => json_decode($b->email ?? '[]', true),
					'tel' => json_decode($b->tel ?? '[]', true),
					'fax' => $b->fax,
				];
			}
		}

		return $data;
	}
    
}
