<?php

namespace Modules\Contact\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Mail;
use Modules\Contact\app\Emails\ContactEmail;
use Modules\Contact\app\Models\ContactUs;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\User\app\Models\Users;

class ContactUsController extends AdminController
{
	/**
	 * Function : contact send contact
	 * Dev : Poom
	 * Update Date : 17 Apr 2024
	 * @param \Illuminate\Http\Request $request
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function send(Request $request)
	{
		$role = [
			'first_name' => 'required|max:255',
			'last_name' => 'required|max:255',
			'email' => 'required|email|max:255',
			'tel' => 'required|max:20',
			'subject' => 'required',
			'msg' => 'required|max:255'
		];

		$msg = [
			'first_name.required' => __('frontend::lang.form.first_name.placeholder'),
			'first_name.max' => __('frontend::lang.form.first_name.max', ['max' => 255]),
			'last_name.required' => __('frontend::lang.form.last_name.placeholder'),
			'last_name.max' => __('frontend::lang.form.last_name.max', ['max' => 255]),
			'email.required' => __('frontend::lang.form.email.placeholder'),
			'email.email' => __('frontend::lang.form.email.email'),
			'email.max' => __('frontend::lang.form.email.max', ['max' => 255]),
			'tel.required' => __('frontend::lang.form.tel.placeholder'),
			'tel.max' => __('frontend::lang.form.tel.max', ['max' => 20]),
			'subject.required' => __('frontend::lang.form.subject.placeholder'),
			'msg.required' => __('frontend::lang.form.msg.placeholder'),
			'msg.max' => __('frontend::lang.form.msg.max', ['max' => 255]),
		];

		$valid = validator($request->all(), $role, $msg);
		if ($valid->fails())
			return self::response(['title' => __('noti.title_error'), 'desc' => $valid->errors()->first()], Response::HTTP_MOVED_PERMANENTLY);

		$attr = [
			'name' => $request->get('first_name') . ' ' . $request->get('last_name'),
			'email' => $request->get('email'),
			'tel' => $request->get('tel'),
			'subject' => $request->get('subject'),
			'msg' => $request->get('msg'),
			'accept' => 1,
		];

		$req = ContactUs::create($attr);
		if ($req->save()) {
			$contact = self::arr_contact($req);
			try {
				config_mail();
				$users  = Users::where('status', 1)->get(['id', 'email']);
				foreach ($users as $user) {
					if (mwz_roles('admin.contact.list.index', null, $user->id) || mwz_roles('admin.contact.list.set_delete', null, $user->id)) {
						Mail::to($user->email)->send(new ContactEmail('Contact Us', $contact));
					}
				}
			} catch (\Throwable $th) {
			}

			return self::response(['msg' => __('contact::lang.alert.success')]);
		}

		return self::response(['msg' => __('contact::lang.alert.error')], Response::HTTP_INTERNAL_SERVER_ERROR);
	}

	/**
	 * Function : contact list array data
	 * Dev : Poom
	 * Update Date : 17 Apr 2024
	 * @param mixed $param
	 * @return array data
	 */
	private static function arr_contact($param)
	{
		$config = config('contact.list');

		$data = [
			['name' => __('field.full_name'), 'value' => $param->name],
		];
		if (!empty($config['company']))
			$data[] = ['name' => __('field.company'), 'value' => $param->company];
		if (!empty($config['email']))
			$data[] = ['name' => __('field.email'), 'value' => $param->email];
		if (!empty($config['tel']))
			$data[] = ['name' => __('field.tel'), 'value' => $param->tel];
		if (!empty($config['line_id']))
			$data[] = ['name' => __('field.line'), 'value' => $param->line_id];
		if (!empty($config['subject']))
			$data[] = ['name' => __('field.subject'), 'value' => $param->subject_opt->local->name ?? null];
		if (!empty($config['msg']))
			$data[] = ['name' => __('field.msg'), 'value' => $param->msg];

		return $data;
	}
}
