<?php

namespace Modules\Contact\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Modules\Contact\app\Models\Subjects;

class SubjectsController extends Controller
{
	/**
	 * Function : get list subject
	 * Dev : Petch
	 * Update Date : 14 May 2024
	 */
	public static function get_list($option = [])
	{
		$data = [];
		$req = Subjects::where('status', 1)
			->orderBy($option['column'] ?? 'sequence', $option['dir'] ?? 'ASC')
			->get();

		if (!empty($req)) {
			foreach ($req as $item) {
				$data[] = [
					'id' => $item->id,
					'name' => $item->local->name ?? '',
				];
			}
		}

		return $data;
	}
}
