<?php

namespace Modules\Contact\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Contact\app\Models\Subscribes;
use Modules\Mwz\app\Http\Controllers\AdminController;

class SubscribeAdminController extends AdminController
{
    public function __construct()
    {
        $this->middleware('auth:admin');
        self::$navbar = [
            ['name' => __("contact::subscribe.title"), 'url' => null],
            ['name' => __("contact::subscribe.name"), 'url' => route_has("admin.contact.subscribe.index")]
        ];
    }

    /**
     * Function : subscribe index
     * Dev : Poom
     * Update Date : 17 Apr 2024
     * @return \Illuminate\Contracts\View\View contact::subscribe.index
     */
    public function index()
    {
        return view('contact::subscribe.index', ['navbar' => self::$navbar]);
    }

    /**
     * Function : subscribe datatable ajax
     * Dev : Poom
     * Update Date : 17 Apr 2024
     * @param \Illuminate\Http\Request $request
     * @return Yajra\DataTables\Facades\DataTables data table
     */
    public function datatable_ajax(Request $request)
    {
        if ($request->ajax()) {
            //init datatable
            $dt_column = ['id', 'email', 'created_at', 'action'];
            $dt_order = $request->get('order')[0]['column'];
            $dt_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];
            $dt_filter = $request->get('filter');
            // create contactus object
            $req = new Subscribes();

            // add search query if have search from datable
            if (!empty($dt_search)) {
                $req = $req->where(function ($query) use ($dt_search) {
                    $query->where('created_at', 'like', "%$dt_search%")
                        ->orwhere('email', 'like', "%$dt_search%");
                });
            }

            if (!empty($dt_filter['period']))
                $req = $this->mwz_filter($req, $dt_filter['period'], 'created_at', $dt_filter['start_at'] ?? '', $dt_filter['end_at'] ?? '');


            $dt_total = $req->count();
            // set query order & limit from datatable
            $resps = $req->orderBy($dt_column[$dt_order], $dt_dir)
                ->offset($dt_start)
                ->limit($dt_length)
                ->get();

            // prepare datatable for resonse
            $tables = datatables($resps)
                ->addIndexColumn()
                ->setRowId('id')
                ->setRowClass('subscribe_row')
                ->setTotalRecords($dt_total)
                ->setFilteredRecords($dt_total)
                ->setOffset($dt_start)
                ->editColumn('email', function ($record) {
                    return $record->email ?? '';
                })->editColumn('created_at', function ($record) {
                    return str_replace(' ', '<br>', date("Y-m-d H:i:s", strtotime($record->created_at)));
                })->editColumn('action', function ($record) {
                    $btn = '<div class="button-list">';
                    $btn .= self::btn_delete("admin.contact.subject.set_delete", $record->id, 'setDelete');
                    $btn .= '</div>';
                    return $btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }


    /**
     * Function : subscribe set delete
     * Dev : Poom
     * Update Date : 17 Apr 2024
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function set_delete(Request $request)
    {
        $set = Subscribes::find($request->get('id'));
        if ($set->delete())
            return self::response(['msg' => __('noti.delete')]);

        return self::response(['msg' => __('noti.error')], Response::HTTP_MOVED_PERMANENTLY);
    }
}
