<?php

namespace Modules\Contact\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ContactUs extends Model
{
	use HasFactory;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = ['id', 'name', 'email', 'tel', 'subject', 'msg', 'accept'];
	protected $table = "contact_list";

	public function subject_opt()
	{
		return $this->hasOne(Subjects::class, 'id', 'subject');
	}
}
