<?php

namespace Modules\Contact\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Contact\database\factories\SubjectsFactory;

class Subjects extends Model
{
    use HasFactory;

    protected $fillable = ['id', 'image', 'sequence', 'status', 'created_at', 'updated_at'];
    protected $table = "subjects";
    protected $primaryKey = "id";

    protected static function newFactory(): SubjectsFactory
    {
        return SubjectsFactory::new();
    }
    protected static function boot(): void
    {
        parent::boot();
        static::deleting(function ($model) {
            $model->langs()->delete();
        });
    }

    public function langs()
    {
        return $this->hasMany(SubjectTranslate::class, 'subject_id', 'id');
    }
    public function local()
    {
        return $this->hasOne(SubjectTranslate::class, 'subject_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
    }
    public function default()
    {
        return $this->hasOne(SubjectTranslate::class, 'subject_id', 'id')->where('lang', config('app.fallback_locale'));
    }
}
