
$(document).ready(function () {
	initDatatable()
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	if ($("#subject-datatable").length > 0) {
		var column = [{ data: "DT_RowIndex", className: 'text-center' }];
		($_config.upload.status) && column.push({ data: "image", orderable: false, className: 'text-center' });
		($_config.input.name.status) && column.push({ data: "name", orderable: true });
		column.push(
			{ data: "sort", orderable: false, className: 'text-center' },
			{ data: "updated_at", orderable: true },
			{ data: "action", orderable: false, className: 'text-center' }
		);
		const oTable = $("#subject-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/contact/subject/datatable_ajax",
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: column,
			language: $_LANG.datatable,
		});
		init_Table();
		oTable.on("row-reorder", function (e, diff, edit) {
			var moving = {};
			$.each(diff, function (key, row) {
				var at = oTable.row(row.node).data();
				moving[at.id] = row.newData;
			});
			var sort_json = JSON.stringify(moving);
			$.ajax({
				url: "/admin/contact/subject/set_re_order",
				type: "POST",
				data: { sort_json: sort_json, },
				headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
				success: function (resp) {
					mwz_noti("success", resp.msg, setReloadDataTable());
				},
				error: function (xhr, status, thrown) {
					ajax_error(xhr, status, thrown);
				}
			});
		});
	}
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	($("#subject-datatable").length > 0) &&
		$("#subject-datatable").DataTable().ajax.reload(null, bool);
}
/**
* Function : Status
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setStatus = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/contact/subject/set_status",
		type: "POST",
		data: { id: id },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	})
};
/**
* Function : Delete
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/contact/subject/set_delete",
		type: "POST",
		data: { id: id, },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});

};
/**
* Function : Sort
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSort = function (id, move) {
	event.preventDefault();
	$.ajax({
		url: "/admin/contact/subject/set_sort",
		type: "POST",
		data: { id: id, move: move },
		headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};
/**
* Function : Save
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();

	var frm = $("#subject_frm");
	var frm_data = new FormData($(frm)[0]);

	$.ajax({
		url: '/admin/contact/subject/save',
		type: "POST",
		data: frm_data,
		contentType: false,
		processData: false,
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"), },
		beforeSend: function (xhr) {
			// validate
			var rules = [], msg = [];

			$.each($_lang, function (i, lang) {
				$.each($_config.input, function (key, ele) {
					rules[`${key}_${lang}`] = (key == "name") ? { required: ele.validate && ele.status, maxlength: 255 } : { required: ele.validate && ele.status };
					msg[`${key}_${lang}`] = { required: $(frm).find(`[name="${key}_${lang}"]`).attr('placeholder') };
				});
			});

			mwz_validate($(frm), rules, msg);
			return frm_valid($(frm));
		},
		success: function (resp) {
			mwz_noti("success", resp.msg, window.location.replace("/admin/contact/subject/"));
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};