$(document).ready(function () {
	initDatatable()
})
/**
* Function : Init Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.initDatatable = function () {
	if ($("#subscribe-datatable").length > 0) {
		var column = [
			{ data: "DT_RowIndex", orderable: true, className: 'text-center' },
			{ data: "email", orderable: true },
			{ data: "created_at", orderable: true },
			{ data: "action", orderable: false, className: 'text-center' }
		];
		$("#subscribe-datatable").DataTable({
			processing: true,
			serverSide: true,
			stateSave: true,
			ajax: {
				url: "/admin/contact/subscribe/datatable_ajax",
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: column,
			language: $_LANG.datatable,
		});
		init_Table();
	}
}
/**
* Function : Reload Datatable
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setReloadDataTable = function (bool = false) {
	($("#subscribe-datatable").length > 0) &&
		$("#subscribe-datatable").DataTable().ajax.reload(null, bool);
}
/**
* Function : Delete
* Dev : Poom
* Update Date : 26 Apr 2024
*/
window.setDelete = function (id) {
	event.preventDefault();
	$.ajax({
		url: "/admin/contact/subscribe/set_delete",
		type: "POST",
		data: { id: id, },
		headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
		success: function (resp) {
			mwz_noti("success", resp.msg, setReloadDataTable());
		},
		error: function (xhr, status, thrown) {
			ajax_error(xhr, status, thrown);
		}
	});
};