<div class="card card-body">
    <div class="row">
        @if (!empty($contact['email']['status']))
            @if (!empty($contact['email']['multiple']))
                <div class="col-lg mb-2">
                    @for ($i = 0; $i < 5; $i++)
                        @if ($i == 0)
                            <div class="col-lg mb-2">
                                <x-form.input name="email[]" type="mail" value="{{ $data->email[0] ?? null }}" label="{{ __('field.email') }}" placeholder="{{ __('field.email_placeholder') }}" required="{{ $input['email']['validate'] ?? false }}" />
                            </div>
                        @endif
                        @if ($i > 0)
                            <div class="input-group {{ !empty($data->email[$i]) ? '' : 'd-none' }} mb-2" id="email_show_{{ $i }}">
                                <span class="input-group-text"><i class="fe-mail"></i></span>
                                <input class="form-control" id="email_{{ $i }}" name="email[]" type="email" value="{{ $data->email[$i] ?? null }}" placeholder="{{ __('field.email_placeholder') }}">
                                <div class="input-group-append" onclick='DeleteEmail({{ $i }},"email_show_","btn_email");'>
                                    <span class="input-group-text bg-white"><i class="mdi mdi-delete"></i></span>
                                </div>
                            </div>
                        @endif
                    @endfor
                    <div class="col-12 d-flex justify-content-end" id="btn_email">
                        <button class="btn btn-outline-dark btn-xs" type="button" onclick='EmailShow("email_show_","btn_email");'>+</button>
                    </div>
                </div>
            @else
                <div class="col-lg mb-2">
                    <x-form.input name="email" type="mail" value="{{ $data->email ?? null }}" label="{{ __('field.email') }}" placeholder="{{ __('field.email_placeholder') }}" required="{{ $input['email']['validate'] ?? false }}" />
                </div>
            @endif

        @endif
        @if (!empty($contact['tel']['status']))
            @if (!empty($contact['tel']['multiple']))
                <div class="col-lg mb-2">
                    @for ($i = 0; $i < 5; $i++)
                        @if ($i == 0)
                            <div class="col-lg mb-2">
                                <x-form.input name="tel[]" type="{{ $input['tel']['type'] ?? 'input' }}" value="{{ $data->tel[0] ?? null }}" label="{{ __('field.tel') }}" placeholder="{{ __('field.tel_placeholder') }}" required="{{ $input['tel']['validate'] ?? false }}" maxlength="100" />
                            </div>
                        @endif
                        @if ($i > 0)
                            <div class="input-group {{ !empty($data->tel[$i]) ? '' : 'd-none' }} mb-2" id="tel_show_{{ $i }}">
                                <span class="input-group-text"><i class="fe-phone-call"></i></span>
                                <input class="form-control" id="tel_{{ $i }}" name="tel[]" type="tel" value="{{ $data->tel[$i] ?? null }}" placeholder="{{ __('field.tel_placeholder') }}" onkeypress="InputValidateString();" @if (!empty($readonly)) readonly @endif maxlength="100">
                                <div class="input-group-append" onclick='DeletePhone({{ $i }},"tel_show_","btn_show");'>
                                    <span class="input-group-text bg-white"><i class="mdi mdi-delete"></i></span>
                                </div>
                            </div>
                        @endif
                    @endfor
                    <div class="col-12 d-flex justify-content-end" id="btn_show">
                        <button class="btn btn-outline-dark btn-xs" type="button" onclick='PhoneShow("tel_show_","btn_show");'>+</button>
                    </div>
                </div>
            @else
                <div class="col-lg mb-2">
                    <x-form.input name="tel" type="{{ $input['tel']['type'] ?? 'input' }}" value="{{ $data->tel ?? null }}" label="{{ __('field.tel') }}" placeholder="{{ __('field.tel_placeholder') }}" required="{{ $input['tel']['validate'] ?? false }}" />
                </div>
            @endif
        @endif


        @if (!empty($input['fax']['status']))
            @if (!empty($input['fax']['multi']))
                <div class="col-lg mb-2">
                    @for ($i = 0; $i < 5; $i++)
                        @if ($i == 0)
                            <div class="col-lg mb-2">
                                <x-form.input name="fax[]" type="{{ $input['fax']['type'] ?? 'input' }}" value="{{ $data->fax[0] ?? null }}" label="{{ __('field.fax') }}" placeholder="{{ __('field.fax_placeholder') }}" required="{{ $input['fax']['validate'] ?? false }}" maxlength="10" minlength="10" />
                            </div>
                        @endif
                        @if ($i > 0)
                            <div class="input-group {{ !empty($data->fax[$i]) ? '' : 'd-none' }} pb-2" id="fax_show_{{ $i }}">
                                <span class="input-group-text"><i class="fe-phone-call"></i></span>
                                <input class="form-control" id="fax_{{ $i }}" name="fax[]" type="fax" value="{{ $data->fax[$i] ?? null }}" placeholder="{{ __('field.fax_placeholder') }}" onkeypress="InputValidateString();" @if (!empty($readonly)) readonly @endif maxlength="10" minlength="10">
                                <div class="input-group-append" onclick='DeletePhone({{ $i }},"fax_show_","btn_show");'>
                                    <span class="input-group-text"><i class="mdi mdi-delete"></i></span>
                                </div>
                            </div>
                        @endif
                    @endfor
                    <div class="col-12 d-flex justify-content-end" id="btn_show">
                        <button class="btn btn-info btn-sm" type="button" onclick='PhoneShow("fax_show_","btn_show");'>+</button>
                    </div>
                </div>
            @else
                <div class="col-lg mb-2">
                    <x-form.input name="fax" type="{{ $input['fax']['type'] ?? 'input' }}" value="{{ $data->fax ?? null }}" label="{{ __('field.fax') }}" placeholder="{{ __('field.fax_placeholder') }}" required="{{ $input['fax']['validate'] ?? false }}" />
                </div>
            @endif
        @endif

    </div>
    @if (!empty($input['gmap']['status']))
        <div class="mb-2">
            <x-form.input name="gmap" type="{{ $input['gmap']['type'] ?? 'input' }}" value="{{ $data->google_map ?? null }}" rows="3" label="{{ __('field.gmap') }}" placeholder="{{ __('field.gmap_placeholder') }}" required="{{ $input['gmap']['validate'] ?? false }}" />
        </div>
    @endif

    @if (!empty($config['social']))
        @foreach ($config['social'] as $key => $item)
            @if (!empty($item['status']))
                <?php $param = $data->{$key} ?? null; ?>
                <x-form.socials name="{{ $key }}" name_url="{{ $item['name'] }}" label='{{ __("contact::info.field.{$key}") }}' :param=$param url="{{ $item['url'] ?? false }}" msg="{{ $item['msg'] ?? false }}" />
            @endif
        @endforeach
    @endif
</div>
<script>
    var clicks = 0;
    DeletePhone = function(res, frm_id, btn_id) {
        clicks -= 1;
        $("#" + frm_id + res).addClass('d-none');
        if (clicks < 4) {
            $("#" + btn_id).removeClass('d-none')
        }
        $("#tel_" + res).val("");
    }
    PhoneShow = function(frm_id, btn_id) {
        console.log(frm_id, btn_id);
        clicks += 1;
        $("#" + frm_id + clicks).removeClass('d-none');
        if (clicks >= 4) {
            $("#" + btn_id).addClass('d-none')
        }
    }

    var clicks_email = 0;
    DeleteEmail = function(res, frm_id, btn_id) {
        clicks_email -= 1;
        $("#" + frm_id + res).addClass('d-none');
        if (clicks_email < 4) {
            $("#" + btn_id).removeClass('d-none')
        }
        $("#email_" + res).val("");
    }
    EmailShow = function(frm_id, btn_id) {
        console.log(frm_id, btn_id);
        clicks_email += 1;
        $("#" + frm_id + clicks_email).removeClass('d-none');
        if (clicks_email >= 4) {
            $("#" + btn_id).addClass('d-none')
        }
    }
</script>

