<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => 'admin', 'middleware' => ['auth:admin', 'adminAccessControl']], function () {
	Route::prefix('contact')->group(function () {
		Route::prefix('info')->group(function () {
			Route::get('/', 'ContactInfoAdminController@index')->name('admin.contact.info.index');
			Route::post('/save', 'ContactInfoAdminController@save')->name('admin.contact.info.edit');
		});

		Route::prefix('branch')->group(function () {
		    Route::get('/', 'BranchAdminController@index')->name('admin.contact.branch.index');
		    Route::get('/datatable_ajax', 'BranchAdminController@datatable_ajax')->name('admin.contact.branch.datatable_ajax');

		    Route::get('/add', 'BranchAdminController@form')->name('admin.contact.branch.add');
		    Route::get('/edit/{id}', 'BranchAdminController@form')->name('admin.contact.branch.edit');
		    Route::post('/save', 'BranchAdminController@save')->name('admin.contact.branch.save');

		    Route::post('/set_status', 'BranchAdminController@set_status')->name('admin.contact.branch.set_status');
		    Route::post('/set_delete', 'BranchAdminController@set_delete')->name('admin.contact.branch.set_delete');
		    Route::post('/set_re_order', 'BranchAdminController@set_re_order')->name('admin.contact.branch.set_re_order');
		    Route::post('/set_sort', 'BranchAdminController@set_sort')->name('admin.contact.branch.set_sort');

		    Route::post('/get_list', 'BranchAdminController@get_list')->name('admin.contact.branch.get_list');
		});

		Route::prefix('other')->group(function () {
		    Route::get('/', 'BranchAdminController@index')->name('admin.contact.other.index');
		    Route::get('/datatable_ajax', 'BranchAdminController@datatable_ajax')->name('admin.contact.other.datatable_ajax');

		    Route::get('/add', 'BranchAdminController@form')->name('admin.contact.other.add');
		    Route::get('/edit/{id}', 'BranchAdminController@form')->name('admin.contact.other.edit');
		    Route::post('/save', 'BranchAdminController@save')->name('admin.contact.other.save');

		    Route::post('/set_status', 'BranchAdminController@set_status')->name('admin.contact.other.set_status');
		    Route::post('/set_delete', 'BranchAdminController@set_delete')->name('admin.contact.other.set_delete');
		    Route::post('/set_re_order', 'BranchAdminController@set_re_order')->name('admin.contact.other.set_re_order');
		    Route::post('/set_sort', 'BranchAdminController@set_sort')->name('admin.contact.other.set_sort');

		    Route::post('/get_list', 'BranchAdminController@get_list')->name('admin.contact.other.get_list');
		});
		

		Route::prefix('subject')->group(function () {
			Route::get('/', 'SubjectsAdminController@index')->name('admin.contact.subject.index');
			Route::get('/datatable_ajax', 'SubjectsAdminController@datatable_ajax')->name('admin.contact.subject.datatable_ajax');

			Route::get('/add', 'SubjectsAdminController@form')->name('admin.contact.subject.add');
			Route::get('/edit/{id}', 'SubjectsAdminController@form')->name('admin.contact.subject.edit');
			Route::get('/view/{id}', 'SubjectsAdminController@form')->name('admin.contact.subject.view');
			Route::post('/save', 'SubjectsAdminController@save')->name('admin.contact.subject.save');

			Route::post('/set_status', 'SubjectsAdminController@set_status')->name('admin.contact.subject.set_status');
			Route::post('/set_delete', 'SubjectsAdminController@set_delete')->name('admin.contact.subject.set_delete');
			Route::post('/set_re_order', 'SubjectsAdminController@set_re_order')->name('admin.contact.subject.set_re_order');
			Route::post('/set_sort', 'SubjectsAdminController@set_sort')->name('admin.contact.subject.set_sort');
		});

		Route::prefix('list')->group(function () {
			Route::get('/', 'ContactUsAdminController@index')->name('admin.contact.list.index');
			Route::get('/datatable_ajax', 'ContactUsAdminController@datatable_ajax')->name('admin.contact.list.datatable_ajax');
			Route::get('/view/{id}', 'ContactUsAdminController@form')->name('admin.contact.list.view');
			Route::post('/set_delete', 'ContactUsAdminController@set_delete')->name('admin.contact.list.set_delete');
			Route::post('/export', 'ContactUsAdminController@export')->name('admin.contact.list.export');
		});

		// Route::prefix('subscribe')->group(function () {
		//     Route::get('/', 'SubscribeAdminController@index')->name('admin.contact.subscribe.index');
		//     Route::get('/datatable_ajax', 'SubscribeAdminController@datatable_ajax')->name('admin.contact.subscribe.datatable_ajax');

		//     Route::post('/set_delete', 'SubscribeAdminController@set_delete')->name('admin.contact.subscribe.set_delete');
		// });
	});
});
