import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
	build: {
		outDir: '../../public/build-contact',
		emptyOutDir: true,
		manifest: true,
	},
	plugins: [
		laravel({
			publicDirectory: '../../public',
			buildDirectory: 'build-contact',
			input: [
				__dirname + '/resources/assets/sass/app.scss',
				__dirname + '/resources/assets/js/info.js',
				__dirname + '/resources/assets/js/list.js',
				__dirname + '/resources/assets/js/branch.js',
				__dirname + '/resources/assets/js/subject.js',
				__dirname + '/resources/assets/js/subscribe.js'
			],
			refresh: true,
		}),
	],
});

//export const paths = [
//    'Modules/$STUDLY_NAME$/resources/assets/sass/app.scss',
//    'Modules/$STUDLY_NAME$/resources/assets/js/app.js',
//];


