<?php

namespace Modules\Content\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Modules\Content\app\Models\Pages;
use Modules\Mwz\app\Http\Controllers\SlugController;

class ContentPageController extends Controller
{
	/**
	 * Function : page
	 * Dev : Petch
	 * Update Date : 4 March 2025
	 */
	public static function page($type = '', $option = [])
	{
		$data = [];
		$config = config("content.page.{$type}");
		$navbar_c = $config['form']['navbar'];
		$sidebar_c = $config['form']['sidebar'];
		$query =  Pages::where('type', $type);

		if (!empty($option['status']))
			$query = $query->where('status', 1);

		$page = $query->with(['local'])->first();

		if (!empty($page)) {
			foreach ($navbar_c as $k => $v) {
				if (empty($v['status']))
					continue;

				if ($k == 'seo')
					$data['url'] = SlugController::getRoute($page->type, $page->type, $page->id) ?? '';
				else {
					foreach ($v['input'] as $k_i => $i) {
						if (empty($i['status']))
							continue;

						if ($k == 'translate')
							$data[$k_i] = mwz_getTextString($page->local->{$k_i} ?? '', $i['type'] == 'texteditor');
						elseif ($i['type'] == 'gallery')
							$data[$k_i] = json_decode($page->{$k_i}, true);
						else
							$data[$k_i] = $page->{$k_i} ?? '';
					}
				}
			}

			foreach ($sidebar_c as $k => $v) {
				if (empty($v['status']) || $k == 'lang')
					continue;

				foreach ($v['input'] as $k_i => $i) {
					if (empty($i['status']))
						continue;

					$data[$k_i] = $page->{$k_i} ?? '';
				}
			}
		}

		return $data;
	}
}
