<?php

namespace Modules\Content\app\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\App;
use Modules\Content\app\Models\Contents;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Mwz\app\Http\Controllers\SlugController;

class ContentsController extends AdminController
{
	/**
	 * Function : get list
	 * Dev : Petch
	 * Update Date : 5 March 2025
	 */
	public static function get_list($type, $option = [])
	{
		$data = [];
		$per_page = $all = 0;
		$config = config("content.content.{$type}");
		$config_category = config("content.category.{$type}");
		$navbar_c = $config['form']['navbar'];
		$sidebar_c = $config['form']['sidebar'];

		$req = Contents::where([['type', $type], ['status', 1]]);
		if (!empty($option['id']))
			$req = $req->where('id', $option['id']);

		if (!empty($option['search'])) {
			$req = $req->where(function ($query) use ($option) {
				$query = $query->whereRelation('local', 'name', 'LIKE', "%{$option['search']}%");
				if (!empty($option['search_detail']))
					$query = $query->orWhereRelation('local', 'detail', 'LIKE', "%{$option['search']}%");
			});
		}

		if (!empty($option['category_id']) && $option['category_id'] > 0)
			$req = $req->whereRelation('categories', 'category_id', $option['category_id']);
		elseif (!empty($config_category))
			$req = $req->whereRelation('categories', 'content_categories.status', 1);

		if (!empty($config['publish_at']))
			$req = $req->where('publish_at', '<=', now());

		if (isset($option['default']))
			$req = $req->where('default', $option['default'] ? 1 : 0);

		if (!empty($option['per_page']) && $option['per_page']) {
			$data['cur_page'] = $option['cur_page'] ?? 1;
			$per_page = intval($option['per_page']);

			$all = $req->count();
			$offset = ($data['cur_page'] - 1) * $per_page;

			if (!empty($option['skip'])) {
				$offset += $option['skip'];
				$all -= $option['skip'];
				$all = $all < 0 ? 0 : $all;
			}

			$data['total'] = (int) ceil((int)$all / $per_page);
			$req = $req->limit($per_page)->offset($offset);
		} elseif (!empty($option['limit']))
			$req = $req->limit($option['limit']);

		$req = $req->orderBy($option['column'] ?? '_lft', $option['dir'] ?? 'ASC')
			->with(['local', 'categories.local'])
			->get();

		foreach ($req as $item)
			$data['list'][] = self::mapping($item, $option['full'] ?? false, $navbar_c, $sidebar_c,$option);

		return $data;
	}

	/**
	 * Function : mapping
	 * Dev : Petch
	 * Update Date : 5 March 2025
	 */
	private static function mapping($param, $full = false, $navbar, $sidebar,$option = [])
	{
		$data = [
			'id' => $param->id,
		];
		foreach ($navbar as $k => $v) {
			if (empty($v['status']) || (!$full && in_array($k, ['other'])))
				continue;
			if ($k == 'seo') {
				$slug_main = SlugController::getRoute($option['module'] ?? $param->type, $option['method'] ?? $param->type, 1) ?? "";
				if (!empty($slug_main)) {
					$data['url'] = $slug_main . SlugController::getRouteSub($param->type, "{$param->type}_content", $param->id);
				} else {
					$data['url'] = SlugController::getRoute($param->type, "{$param->type}_content", $param->id);
				}
			} else {
				foreach ($v['input'] as $k_i => $i) {
					if (empty($i['status']) || (!$full && in_array($k_i, ['detail', 'text', 'location', 'related', 'categories', 'gallery', 'video', 'youtube', 'file'])))
						continue;
					if ($k == 'translate')
						$data[$k_i] = mwz_getTextString($param->local->{$k_i} ?? '', $i['type'] == 'texteditor');
					elseif (str_contains($i['type'], 'upload_image'))
						$data[$k_i] = check_file($param->{$k_i} ?? '');
					elseif ($i['type'] == 'gallery' && !empty($param->{$k_i}))
						$data[$k_i] = json_decode($param->{$k_i}, 1);
					elseif ($i['type'] == 'multiple' && !empty($param->{$k_i}))
						$data[$k_i] = self::multiple($param, $navbar, $sidebar, $k_i);
					else
						$data[$k_i] = $param->{$k_i} ?? '';
				}
			}
		}
		foreach ($sidebar as $k => $v) {
			if (empty($v['status']) || $k == 'lang')
				continue;

			foreach ($v['input'] as $k_i => $i) {
				if (empty($i['status']))
					continue;
				if ($k_i == 'period')
					$data[$k_i] = str_implode(' - ', [str_date($param->{$i['start']}, 'd M Y'), str_date($param->{$i['end']}, 'd M Y')]);
				elseif ($k_i == 'time')
					$data[$k_i] = str_implode(' - ', [date('H:i', strtotime($param->{$i['start']})), date('H:i', strtotime($param->{$i['end']}))]);
				elseif ($k_i == 'categories' && !empty($param->{$k_i}))
					$data[$k_i] = self::multiple($param, $navbar, $sidebar, $k_i);
				elseif ($k_i == 'publish_at'){
					$data[$k_i] = str_date($param->{$k_i} ?? '', 'd M Y');
					$data['day'] = str_date($param->{$k_i} ?? '', 'd');
					$data['month'] = str_date($param->{$k_i} ?? '', 'm');
				}
				else
					$data[$k_i] = $param->{$k_i} ?? '';
			}
		}
		return $data;
	}

	/**
	 * Function : multiple
	 * Dev : Petch
	 * Update Date : 5 March 2025
	 */
	private static function multiple($param, $navbar, $sidebar, $type)
	{
		$data = [];

		if ($type == 'categories') {
			foreach ($param->categories as $c) {
				$data[] = [
					'id' => $c->id,
					'name' => $c->local->name ?? '',
					'url' => SlugController::getRoute($c->type, "{$c->type}_category", $c->id) ?? '',
				];
			}
		} elseif ($type == 'related') {
			foreach ($param->related as $r)
				$data[] = self::mapping($r, false, $navbar, $sidebar);
		}

		return $data;
	}

	/**
	 * Function : click
	 * Dev : Petch
	 * Update Date : 21 March 2025
	 */
	public static function click(Request $request)
	{
		if (empty($request->get('id')))
			return self::response(['msg' => 'Error'], Response::HTTP_BAD_REQUEST);

		$content = Contents::find($request->get('id'));
		if (empty($content))
			return self::response(['msg' => 'Error'], Response::HTTP_BAD_REQUEST);

		$content->view = !empty($content->view) ? $content->view + 1 : 1;
		if ($content->save())
			return self::response(['msg' => 'Success']);

		return self::response(['msg' => 'Error'], Response::HTTP_INTERNAL_SERVER_ERROR);
	}
}
