<?php

namespace Modules\Content\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ContentAndCategory extends Model
{
	use HasFactory;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'type',
		'category_id',
		'content_id',
		'status',
	];
	protected $table = 'content_and_categories';
	protected $primaryKey = 'id';

	public function category()
	{
		return $this->hasOne(ContentCategories::class, 'id', 'category_id');
	}

	public function content()
	{
		return $this->hasOne(Contents::class, 'id', 'content_id');
	}
}
