<?php

namespace Modules\Content\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Kalnoy\Nestedset\NodeTrait;

class ContentCategories extends Model
{
	use HasFactory, NodeTrait;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'type',
		'image',
		'default',
		'parent_id',
		'status',
	];
	protected $table = 'content_categories';
	protected $primaryKey = 'id';

	protected static function boot(): void
	{
		parent::boot();
		static::deleting(function ($model) {
			$model->langs()->delete();
			$model->contents()->detach();
		});
	}

	public function langs()
	{
		return $this->hasMany(ContentCategoryTranslate::class, 'category_id', 'id');
	}

	public function local()
	{
		return $this->hasOne(ContentCategoryTranslate::class, 'category_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
	}

	public function parent()
	{
		return $this->hasOne(ContentCategories::class, 'id', 'parent_id');
	}

	public function contents()
	{
		return $this->belongsToMany(Contents::class, 'content_and_categories', 'category_id', 'content_id');
	}
}
