<?php

namespace Modules\Content\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ContentView extends Model
{
	use HasFactory;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'type',
		'ip',
		'content_id',
		'user_agent',
	];
	protected $table = 'content_view';
	protected $primaryKey = 'id';

	public function content()
	{
		return $this->hasOne(Contents::class, 'id', 'content_id');
	}
}
