<?php

namespace Modules\Content\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Kalnoy\Nestedset\NodeTrait;
use Modules\Mwz\app\Models\Slugs;

class Contents extends Model
{
	use HasFactory, NodeTrait;

	/**
	 * The attributes that are mass assignable.
	 */
	protected $fillable = [
		'type',
		'gallery',
		'image',
		'video',
		'youtube',
		'file',
		'publish_at',
		'start_at',
		'end_at',
		'start_time',
		'end_time',
		'link',
		'view',
		'default',
		'parent_id',
		'style',
		'status',
		'email',
		'phone',
		'gmap',
		'extension',
		'color_code',
	];
	protected $table = 'contents';
	protected $primaryKey = 'id';

	protected static function boot(): void
	{
		parent::boot();
		static::deleting(function ($model) {
			$model->langs()->delete();
			$model->categories()->detach();
			$model->related()->detach();
		});
	}

	public function slug()
	{
		return $this->hasOne(Slugs::class, 'data_id', 'id')
			->where('module', $this->type)
			->where('method', "{$this->type}_content")
			->where('lang', app()->getLocale() ?? config('app.fallback_locale'))
			->select(['slug']);
	}

	public function langs()
	{
		return $this->hasMany(ContentTranslate::class, 'content_id', 'id');
	}

	public function local()
	{
		return $this->hasOne(ContentTranslate::class, 'content_id', 'id')->where('lang', app()->getLocale() ?? config('app.fallback_locale'));
	}

	public function related()
	{
		return $this->belongsToMany(Contents::class, 'content_related', 'content_id', 'related_id');
	}

	public function categories()
	{
		return $this->belongsToMany(ContentCategories::class, 'content_and_categories', 'content_id', 'category_id');
	}
	public function contacts()
	{
		return $this->hasMany(ContactTranslate::class, 'contact_translate_id', 'id');
	}
}
