<?php

use Illuminate\Support\Facades\Route;
use Modules\Content\app\Http\Controllers\ContentCategoryAdminController;
use Modules\Content\app\Http\Controllers\ContentPageAdminController;
use Modules\Content\app\Http\Controllers\ContentsAdminController;
use Modules\Content\app\Http\Controllers\ContentsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['auth:admin', 'adminAccessControl'])->prefix('admin')->name('admin.')->group(function () {
	// ['method', 'url', 'controller', 'name']
	$default_route_page = [
		['get', '/', 'index', 'index'],
		['post', '/save', 'save', 'edit'],
		['post', '/save-gallery', 'save_gallery', 'set_gallery'],
	];
	$default_route_content = [
		['get', '/', 'index', 'index'],
		['get', '/datatable_ajax', 'datatable_ajax', 'datatable_ajax'],
		['get', '/add', 'form', 'add'],
		['get', '/edit/{id?}', 'form', 'edit'],
		['get', '/view/{id?}', 'form', 'view'],
		['post', '/save', 'save', 'save'],
		['post', '/save-gallery', 'save_gallery', 'set_gallery'],
		['post', '/set-sort', 'set_sort', 'set_sort'],
		['post', '/set-default', 'set_default', 'set_default'],
		['post', '/set-status', 'set_status', 'set_status'],
		['post', '/set-delete', 'set_delete', 'set_delete'],
		['post', '/get-list', 'get_list', 'get_list'],
		['post', '/get-category-list', 'get_category_list', 'get_category_list'],
	];
	$default_route_category = [
		['get', '/', 'index', 'index'],
		['get', '/datatable_ajax', 'datatable_ajax', 'datatable_ajax'],
		['get', '/add', 'form', 'add'],
		['get', '/edit/{id}', 'form', 'edit'],
		['get', '/view/{id}', 'form', 'view'],
		['post', '/save', 'save', 'save'],
		['post', '/set-sort', 'set_sort', 'set_sort'],
		['post', '/set-default', 'set_default', 'set_default'],
		['post', '/set-status', 'set_status', 'set_status'],
		['post', '/set-delete', 'set_delete', 'set_delete'],
		['post', '/get-list', 'get_list', 'get_list'],
		['post', '/save-gallery', 'save_gallery', 'set_gallery'],
	];
	Route::prefix('article')->name('article.')->group(function () use ($default_route_page) {
		Route::prefix('page')->name('page.')->group(function () use ($default_route_page) {
			foreach ($default_route_page as $route)
				Route::{$route[0]}($route[1], [ContentPageAdminController::class, $route[2]])->name($route[3]);
		});
	});

	// เกี่ยวกับเรา
	Route::prefix('about')->name('about.')->group(function () use ($default_route_page) {
		Route::prefix('page')->name('page.')->group(function () use ($default_route_page) {
			foreach ($default_route_page as $route)
				Route::{$route[0]}($route[1], [ContentPageAdminController::class, $route[2]])->name($route[3]);
		});
	});

	Route::prefix('index')->name('index.')->group(function () use ($default_route_page) {
		Route::prefix('page')->name('page.')->group(function () use ($default_route_page) {
			foreach ($default_route_page as $route)
				Route::{$route[0]}($route[1], [ContentPageAdminController::class, $route[2]])->name($route[3]);
		});
	});

	Route::prefix('contact')->name('contact.')->group(function () use ($default_route_page) {
		Route::prefix('page')->name('page.')->group(function () use ($default_route_page) {
			foreach ($default_route_page as $route)
				Route::{$route[0]}($route[1], [ContentPageAdminController::class, $route[2]])->name($route[3]);
		});
	});

	//ข่าวสารและกิจกรรม
	Route::prefix('news')->name('news.')->group(function () use ($default_route_content, $default_route_category,$default_route_page) {
		Route::prefix('content')->name('content.')->group(function () use ($default_route_content) {
			foreach ($default_route_content as $route)
				Route::{$route[0]}($route[1], [ContentsAdminController::class, $route[2]])->name($route[3]);
		});
		Route::prefix('page')->name('page.')->group(function () use ($default_route_page) {
			foreach ($default_route_page as $route)
				Route::{$route[0]}($route[1], [ContentPageAdminController::class, $route[2]])->name($route[3]);
		});
	});

	//สินค้า
	Route::prefix('products')->name('products.')->group(function () use ($default_route_content, $default_route_category,$default_route_page) {
		Route::prefix('content')->name('content.')->group(function () use ($default_route_content) {
			foreach ($default_route_content as $route)
				Route::{$route[0]}($route[1], [ContentsAdminController::class, $route[2]])->name($route[3]);
		});
		Route::prefix('category')->name('category.')->group(function () use ($default_route_category) {
			foreach ($default_route_category as $route)
				Route::{$route[0]}($route[1], [ContentCategoryAdminController::class, $route[2]])->name($route[3]);
		});
		Route::prefix('page')->name('page.')->group(function () use ($default_route_page) {
			foreach ($default_route_page as $route)
				Route::{$route[0]}($route[1], [ContentPageAdminController::class, $route[2]])->name($route[3]);
		});
	});

	// news 
	Route::prefix('news')->name('news.')->group(function () use ($default_route_content, $default_route_category) {
		Route::prefix('content')->name('content.')->group(function () use ($default_route_content) {
			foreach ($default_route_content as $route)
				Route::{$route[0]}($route[1], [ContentsAdminController::class, $route[2]])->name($route[3]);
		});
		Route::prefix('category')->name('category.')->group(function () use ($default_route_category) {
			foreach ($default_route_category as $route)
				Route::{$route[0]}($route[1], [ContentCategoryAdminController::class, $route[2]])->name($route[3]);
		});
	});

	//service 
	Route::prefix('service')->name('service.')->group(function () use ($default_route_content, $default_route_page) {
		Route::prefix('content')->name('content.')->group(function () use ($default_route_content) {
			foreach ($default_route_content as $route)
				Route::{$route[0]}($route[1], [ContentsAdminController::class, $route[2]])->name($route[3]);
		});
		Route::prefix('page')->name('page.')->group(function () use ($default_route_page) {
			foreach ($default_route_page as $route)
				Route::{$route[0]}($route[1], [ContentPageAdminController::class, $route[2]])->name($route[3]);
		});
	});
	
});

Route::middleware(['apiLocale'])->prefix('api/v1')->name('api.')->group(function () {
	Route::prefix('content')->name('content.')->group(function () {
		Route::post('/click', [ContentsController::class, 'click'])->name('click');
	});
});
