<?php

namespace Modules\Frontend\Livewire\Card;

use Livewire\Component;
use Modules\Content\app\Http\Controllers\ContentsController;
use Modules\Frontend\Traits\WithPaginationLogic;

class News extends Component
{
    use WithPaginationLogic;
    public $category_id ,$type,$lists;
    public $page_total , $pages ,$per_page = 12 ,$cur_page = 1;

    public function render()
    {
        $news = ContentsController::get_list($this->type,['per_page' => $this->per_page,'cur_page' => $this->cur_page,'full' => true,'column' => 'publish_at','dir' => 'DESC']);
        $this->lists = $news['list'];
		$this->page_total = $news['total'] ?? 1;
		$this->pages = setPagination($this->cur_page, $this->page_total);
        return view('frontend::livewire.card.news');
    }
}
