<?php

namespace Modules\Frontend\Livewire\Form;

use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Attributes\Validate;
use Livewire\Component;
use Modules\Contact\app\Models\ContactUs;
use Modules\Frontend\app\Http\Controllers\FrontendInitController;
use Modules\User\app\Models\Users;

class Contact extends Component
{
    use LivewireAlert;
    
    public $success = "", $emit;
    public $captcha = null;
    public $page_init, $open_modal = false;
    public $subjects = [];

    #[Validate('required')]
    public $name = '';

    #[Validate('required')]
    public $lname = '';

    #[Validate('required|email')]
    public $email = '';

    #[Validate('required')]
    public $tel = '';

    #[Validate('required')]
    public $subject = '';

    #[Validate('required')]
    public $msg = '';

    #[Validate('required')]
    public $accept = '';

    #[Validate('required')]
    public $recaptcha = '';

    #[On('refresh-list')]
    public function refresh() {}
    
    public function render()
    {
        $init = new FrontendInitController;
        $this->page_init = $init->pageInit(request());
        return view('frontend::livewire.form.contact');
    }

    
    public function save()
    {
        if ($this->name == '' || $this->email == '' || $this->tel == '' || $this->subject == '' || $this->msg == '' || $this->accept == '' || $this->captcha == '') {
            $this->validate();
        } else {
            $attributes = [
                "name" => $this->name,
                "email" => $this->email,
                "tel" => $this->tel,
                "subject" => $this->subject,
                "msg" => $this->msg,
                "status" => 0
            ];
            dd($attributes);
            
            // Create and save in one step using create() only
            $contact_us = ContactUs::create($attributes);

            // $this->send_email($contact_us);
            
            // Show success alert
            if (!empty($contact_us->id)) {
                $this->alert('success', __('frontend.modal_title'), [
                    'position' => 'center',
                    'toast' => false,
                    'showConfirmButton' => true,
                    'confirmButtonText' => __('frontend.modal_footer'),
                    'html' => '
                        <p class="text-gray-600 text-lg max-w-md mx-auto leading-relaxed">' . __('frontend.modal_content') . '</p>
                    ',
                    'customClass' => [
                        'popup' => 'rounded-4xl',
                        'confirmButton' => 'button-primary bg-secondary inline-flex items-center justify-center px-9 font-semibold py-3 bg-primary text-white text-md font-medium rounded-full hover:bg-secondary transition duration-300 cursor-pointer swal2-confirm',
                        'icon' => 'inline-flex items-center justify-center size-20 bg-green-100 rounded-full mb-4'
                    ],
                    'showClass' => [
                        'popup' => 'animate__animated animate__fadeIn'
                    ],
                    'hideClass' => [
                        'popup' => 'animate__animated animate__fadeOut'
                    ],
                    'allowOutsideClick' => false,
                    'allowEscapeKey' => false,
                    'timer' => null,
                    'onConfirmed' => 'function() { Livewire.dispatch("clearFields"); }',
                ]);
                
                $this->clearFields();
            }
        }
    }

    #[On('clearFields')]
    private function clearFields()
    {
        $this->name = '';
        $this->email = '';
        $this->tel = '';
        $this->subject = '';
        $this->msg = '';
        $this->accept = '';
        $this->captcha = '';
    }

    public function send_email($contact_us)
    {
        $user = Users::where('status', 1)->get();
        $param = [
            "name" => $this->name,
            "email" => $this->email,
            "tel" => $this->tel,
            "subject" => $contact_us->subject_opt->local->name ?? '',
            "msg" => $this->msg,
        ];
        $contact = $this->arr_contact($param);

        $users = Users::where('status', 1)->get(['id', 'email']);
        // foreach ($users as $user) {
        //     if (mwz_roles('admin.contact.list.index', null, $user->id) || mwz_roles('admin.contact.list.set_delete', null, $user->id)) {
        //         Mail::to($user->email)->send(new ContactUsEmail($contact_us->subject_opt->local->name, $contact));
        //     }
        // }
    }

    /**
     * Function : contact list array data
     * Dev : Wan
     * Update Date : 17 Apr 2024
     * @param mixed $param
     * @return array data
     */
    private function arr_contact($param)
    {
        $data = [
            ['name' => __('field.name'), 'value' => $param['name'] ?? ''],
            ['name' => __('field.email'), 'value' => $param['email']],
            ['name' => __('field.tel'), 'value' => $param['tel']],
            ['name' => __('field.subject'), 'value' => $param['subject'] ?? ''],
            ['name' => __('field.detail'), 'value' => $param['msg']],
            // ['name' => __('field.created'), 'value' => !empty($param->created_at) ? str_date($param->created_at, 'd m Y H:i') : str_date(today(),'d m Y H:i')]
        ];
        return $data;
    }

    private function close_modal()
    {
        $this->dispatch('close-send-message-modal');
    }
}
