<?php

namespace Modules\Frontend\app\Emails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class resetPassword extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public function __construct($title, $link)
    {
        $this->title = $title;
        $this->link = $link;
    }

    /**
     * Build the message.
     */
    public function build(): self
    {
        $copy_right = setting()->local->copy_right ?? date('Y') . ' บริษัทของคุณ. สงวนลิขสิทธิ์.';
        return $this->view('frontend::emails.reset-password', [
            'title' => $this->title,
            'link' => $this->link,
            'copy_right' => $copy_right,
        ]);
    }
}

