<?php

namespace Modules\Frontend\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Modules\Contact\app\Http\Controllers\ContactController;
use Modules\Map\app\Models\CheckInOut;
use Modules\Member\app\Models\Member;
use Modules\Menu\app\Http\Controllers\MenuController;
use Modules\Mwz\app\Models\Slugs;
use Modules\Policy\app\Http\Controllers\PolicyController;
use Modules\Setting\app\Http\Controllers\SettingController;

class FrontendInitController extends Controller
{
	public function pageInit(Request $request)
	{
		$data = [
			'slug_uid' => $request->get('slug_uid'),
			'lang' => app()->getLocale(),
			'lang_switch' => $request->get('lang_switch'),
			'setting' => SettingController::setting(),
			'contact' => ContactController::contact(),
			'menu' => MenuController::get_menu(['parent_id' => [1], 'default' => 1, 'default_condition' => '<>']),
			// 'tag' => TagController::get_tag(),
			'policy' => PolicyController::get_policy(),
			'menu_footer' => MenuController::get_menu(['parent_id' => [2]]),
			// 'menu_nav' => MenuController::get_menu(['parent_id' => [1], 'default' => 1, 'default_condition' => '=']),
		];

		$slug = Slugs::where([
			['lang', $data['lang']],
			['module', 'index'],
			['method', 'index']
		])->first();

		$data['meta'] = $slug ? $slug->toArray() : [
			'meta_title' => '',
			'meta_keywords' => '',
			'meta_description' => '',
			'meta_auther' => '',
			'meta_image' => $data['setting']['logo']['favicon'] ?? ''
		];

		// $data = $this->getMetaActive($request, $data);

		if (!empty($request->metadata)) {
			$data['meta'] = [
				'meta_title' => $request->metadata['meta_title'] ?? $data['meta']['meta_title'],
				'meta_keywords' => $request->metadata['meta_keywords'] ?? $data['meta']['meta_keywords'],
				'meta_description' => $request->metadata['meta_description'] ?? $data['meta']['meta_description'],
				'meta_auther' => $request->metadata['meta_auther'] ?? $data['meta']['meta_auther'],
				'meta_image' => $request->metadata['meta_image'] ?? $data['setting']['logo']['favicon'] ?? '',
			];
		}

		return $data;
	}

	public static function CheckRole()
	{
		$redirect = null;
		$member = Auth::guard('member')->user();
		if (!empty($member)) {
			// dd($member->approve_by_first_id === $member->id,$member->approve_by_second_id === $member->id);
			// dump($member);
			// dump($member->approve_by_first_id === null and $member->approve_by_second_id === null);
			switch ($member->approve_by_first_id === null and $member->approve_by_second_id === null and $member->lavel_id === 1) {
				case true:
					$redirect = route('frontend.recorddatabu');
					break;
				case false:
					$redirect = route('frontend.recorddatamanager');
					break;
			}
			// if ($member->approve_by_first_id === $member->id) {
			// 	$redirect = route('frontend.recorddatamanager');
			// } elseif ($member->approve_by_second_id === $member->id) {
			// 	$redirect = route('frontend.recorddatabu');
			// } else {
			// 	$redirect = route('frontend.check');
			// }
		} else {
			$redirect = route('frontend.login');
		}
		return $redirect;
	}

	/**
	 * Ensure the current member session is still valid and active.
	 */
	public static function ensureActiveMember(): ?RedirectResponse
	{
		if (!Auth::guard('member')->check()) {
			return redirect()->route('frontend.login');
		}

		$member = Auth::guard('member')->user();

		// ตรวจสอบสถานะผู้ใช้
		if (empty($member) || (int)($member->status ?? 0) !== 1) {
			Auth::guard('member')->logout();

			if (session()->has('checkin_id')) {
				session()->forget('checkin_id');
			}

			if (request()->hasSession()) {
				request()->session()->invalidate();
				request()->session()->regenerateToken();
			}

			return redirect()
				->route('frontend.login')
				->with('error', 'บัญชีของคุณถูกปิดการใช้งาน กรุณาติดต่อผู้ดูแลระบบ');
		}

		// ตรวจสอบสถานะระดับพนักงาน (lavel)
		if (empty($member->lavel) || empty($member->lavel->status) || (int)($member->lavel->status ?? 0) !== 1) {
			Auth::guard('member')->logout();

			if (session()->has('checkin_id')) {
				session()->forget('checkin_id');
			}

			if (request()->hasSession()) {
				request()->session()->invalidate();
				request()->session()->regenerateToken();
			}

			return redirect()
				->route('frontend.login')
				->with('error', 'ระดับพนักงานของคุณถูกปิดการใช้งาน กรุณาติดต่อผู้ดูแลระบบ');
		}

		return null;
	}

	/**
	 * ฟังก์ชันนี้สามารถถูกเรียกใช้ได้จากทุกที่ในโค้ด (Global Helper)
	 * ตัวอย่างการใช้งาน : my_global_helper('ข้อความ')
	 *
	 * @param mixed $input
	 * @return mixed
	 */
	public static function check_status_request($status)
	{
		$msg = '';
		if (!empty($status)) {
			if (!empty($status['drive_car']))  $msg .= 'ขับรถ';
			if (!empty($msg))  $msg .= ' | ';
			if (!empty($status['work_time']))  $msg .= 'ลงเวลาทำงาน';
		}
		return $msg;
	}

	public static function status_appove($item)
	{
		$member = Auth::guard('member')->user();
		if (!empty($item->status)) {
			if ($item->status == 1) return '<span class="badge bg-warning text-dark">รอส่งคำขอ</span>';
			if ($item->status == 2) return '<span class="badge bg-warning text-white align-middle py-1">รออนุมัติ</span>'; // manager
			if ($item->status == 3) {
				// dump($member);
				if (!empty($item->member->approve_by_first_id) and $item->member->approve_by_first_id == $member->id) {
					return '<span class="badge bg-success text-white align-middle py-1">อนุมัติ</span>'; // manager
				} else {
					return '<span class="badge bg-warning text-white align-middle py-1">รออนุมัติ</span>'; // BU
				}
			}
			if ($item->status == 4) return '<span class="badge bg-success text-white align-middle py-1">อนุมัติ</span>'; // BU
			if ($item->status == 13) return '<span class="badge bg-danger text-white align-middle py-1">ไม่อนุมัติ</span>';
		}
		return '';
	}

	public static function status_appove_list($status,$member_dt)
	{
		$member = Auth::guard('member')->user();
		if (!empty($status)) {
			if ($status == 1) return '<span class="badge bg-warning text-dark">รอส่งคำขอ</span>';
			if ($status == 2) return '<span class="badge bg-warning text-white align-middle py-1">รออนุมัติ</span>'; // manager
			if ($status == 3) {
				// dump($member);
				if (!empty($member_dt->approve_by_first_id) and $member_dt->approve_by_first_id == $member->id) {
					return '<span class="badge bg-success text-white align-middle py-1">อนุมัติ</span>'; // manager
				} else {
					return '<span class="badge bg-warning text-white align-middle py-1">รออนุมัติ</span>'; // BU
				}
			}
			if ($status == 4) return '<span class="badge bg-success text-white align-middle py-1">อนุมัติ</span>'; // BU
			if ($status == 13) return '<span class="badge bg-danger text-white align-middle py-1">ไม่อนุมัติ</span>';
		}
		return '';
	}


	public static function check_session($data)
	{
		$sessionRedirect = FrontendInitController::ensureActiveMember();
		if ($sessionRedirect instanceof RedirectResponse) {
			return $sessionRedirect;
		}

		$redirect = FrontendInitController::CheckRole();
		if ($redirect instanceof RedirectResponse) {
			return $redirect;
		}
		if (is_string($redirect) && $redirect !== '') {
			$currentUrl = url()->current();
			if ($currentUrl !== $redirect) {
				return redirect()->to($redirect);
			}
		}

		// ตรวจสอบว่ามี checkin ที่ยังไม่ checkout (checkout_time = null และ status = 1)
		// ไม่เกินเวลาเที่ยงคืน ของวันนั้นๆ
		$memberId = Auth::guard('member')->user()->id;
		$today = now()->startOfDay();
		$midnight = now()->endOfDay();

		$activeCheckin = CheckInOut::where('member_id', $memberId)
			->whereNull('checkout_time')
			->where('status', 1)
			->whereBetween('created_at', [$today, $midnight]) // ไม่เกินเวลาเที่ยงคืน ของวันนั้นๆ
			->first();

		// ถ้ามี session checkin_id หรือมี active checkin ในฐานข้อมูล
		// !empty(session()->get('checkin_id'))
		if (!empty($activeCheckin)) {
			// อัปเดต session ถ้ามี active checkin
			if (!empty($activeCheckin) && empty(session()->get('checkin_id'))) {
				session(['checkin_id' => $activeCheckin->id]);
			}
			return view('frontend::checkout_map', $data);
		}
		// กรณีปกติ - logged in และไม่มี checkin active
		return null;
	}

	// เก็บไว้เพื่อ backward compatibility
	public static function check_sesstion($data)
	{
		return self::check_session($data);
	}

	/**
	 * เช็คว่าเป็นคนอนุมัติคนที่เท่าไหร่
	 * คืนค่า "first" ถ้าเป็นผู้อนุมัติลำดับที่ 1, "second" ถ้าเป็นลำดับที่ 2, หรือ null ถ้าไม่ใช่ผู้อนุมัติ
	 */
	public static function CheckPageMenu()
	{
		$member = Auth::guard('member')->user();
		if (!$member) return null;

		$isFirstApprover = Member::where('approve_by_first_id', $member->id)->exists();
		if ($isFirstApprover) {
			return 'first';
		}
		$isSecondApprover = Member::where('approve_by_second_id', $member->id)->exists();
		if ($isSecondApprover) {
			return 'second';
		}
		return null;
	}
}
