{{-- 
  ตัวอย่างการใช้ปุ่ม Logout แบบง่าย
--}}

{{-- วิธีที่ 1: ใช้ Livewire Component (แนะนำ) --}}
<div class="logout-wrapper">
    @livewire('frontend::logout-button')
</div>

{{-- วิธีที่ 2: สร้างปุ่มเอง โดยเชื่อมกับ Livewire --}}
<div>
    <button wire:click="$emit('logout')" class="btn-custom-logout">
        <i class="fas fa-power-off"></i> ออกจากระบบ
    </button>
</div>

{{-- วิธีที่ 3: ใช้ Link ธรรมดา (ไม่แนะนำ เพราะไม่มี CSRF protection) --}}
<form method="POST" action="{{ route('logout') }}" style="display: inline;">
    @csrf
    <button type="submit" class="btn-logout-form">
        <i class="fas fa-sign-out-alt"></i> ออกจากระบบ
    </button>
</form>

{{-- วิธีที่ 4: แสดงเฉพาะเมื่อ Login --}}
@auth
    <div class="user-menu">
        <span>สวัสดี, {{ Auth::user()->name }}</span>
        @livewire('frontend::logout-button')
    </div>
@endauth

{{-- วิธีที่ 5: ปุ่มแบบ Dropdown --}}
<div class="dropdown">
    <button class="dropdown-toggle" data-toggle="dropdown">
        {{ Auth::user()->name }}
        <i class="fas fa-chevron-down"></i>
    </button>
    <div class="dropdown-menu">
        <a href="{{ route('frontend.personalinformation') }}">โปรไฟล์</a>
        <a href="{{ route('frontend.recorddata') }}">บันทึกข้อมูล</a>
        <hr>
        @livewire('frontend::logout-button')
    </div>
</div>

<style>
.logout-wrapper {
    display: inline-block;
}

.btn-custom-logout {
    background: #dc3545;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-custom-logout:hover {
    background: #c82333;
    transform: scale(1.05);
}

.btn-logout-form {
    background: #f44336;
    color: white;
    border: none;
    padding: 8px 16px;
    border-radius: 4px;
    cursor: pointer;
}

.user-menu {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 10px;
    background: #f8f9fa;
    border-radius: 8px;
}

.dropdown {
    position: relative;
    display: inline-block;
}

.dropdown-toggle {
    background: white;
    border: 1px solid #ddd;
    padding: 10px 15px;
    border-radius: 5px;
    cursor: pointer;
}

.dropdown-menu {
    position: absolute;
    top: 100%;
    right: 0;
    background: white;
    border: 1px solid #ddd;
    border-radius: 5px;
    min-width: 200px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    margin-top: 5px;
    display: none;
}

.dropdown:hover .dropdown-menu {
    display: block;
}

.dropdown-menu a {
    display: block;
    padding: 10px 15px;
    color: #333;
    text-decoration: none;
    transition: background 0.3s;
}

.dropdown-menu a:hover {
    background: #f8f9fa;
}

.dropdown-menu hr {
    margin: 5px 0;
    border: none;
    border-top: 1px solid #ddd;
}
</style>

