@extends('frontend::layouts.applogin')

@push('styles')
  <link href="{{ asset('assets/frontend/css/resetpass.css') }}" rel="stylesheet">
@endpush

@section('content')
<!-- ใช้ #login-page และ .login-box เหมือนหน้า login -->
<div id="login-page">
  <div class="login-box">
    <img src="{{ check_file(setting()->logo_header ?? '', asset('assets/frontend/images/logo.png')) }}" alt="Logo">
    <h2>ลืมรหัสผ่าน</h2>
    <p class="subtitle">กรอกอีเมลที่ลงทะเบียนไว้กับระบบ</p>
    <p class="description">ระบบจะส่งลิงก์สำหรับรีเซ็ตรหัสผ่านไปยังอีเมลของคุณ</p>

    <form action="" method="POST">
      @csrf
      
      <div class="form-group">
        <label class="tb-menu-topleft">อีเมล</label>
        <input 
          type="email" 
          name="email" 
          placeholder="example@email.com" 
          required
          class="@error('email') is-invalid @enderror"
        >
        @error('email')
          <span class="text-danger tb-menu-topleft">{{ $message }}</span>
        @enderror
      </div>

      <button type="submit" id="reset-btn">
        <i class="fas fa-paper-plane"></i> ส่งลิงก์รีเซ็ตรหัสผ่าน
      </button>
    </form>

    <div class="back-to-login">
      <a href="{{ route('frontend.login') }}">
        <i class="fas fa-arrow-left"></i> กลับไปหน้าเข้าสู่ระบบ
      </a>
    </div>
  </div>
</div>

@if(session('success'))
<script>
  document.addEventListener('DOMContentLoaded', function() {
    Swal.fire({
      icon: 'success',
      title: 'สำเร็จ!',
      html: '{{ session('success') }}',
      confirmButtonText: 'ตกลง',
      confirmButtonColor: '#28a745',
      showClass: {
        popup: 'animate__animated animate__fadeInDown'
      },
      hideClass: {
        popup: 'animate__animated animate__fadeOutUp'
      }
    });
  });
</script>
@endif

@if(session('error'))
<script>
  document.addEventListener('DOMContentLoaded', function() {
    Swal.fire({
      icon: 'error',
      title: 'เกิดข้อผิดพลาด',
      html: '{{ session('error') }}',
      confirmButtonText: 'ตกลง',
      confirmButtonColor: '#e60303',
      showClass: {
        popup: 'animate__animated animate__fadeInDown'
      },
      hideClass: {
        popup: 'animate__animated animate__fadeOutUp'
      }
    });
  });
</script>
@endif
@endsection

