<?php
$meta = meta();
$setting = setting();
$title = !empty($page_init['meta']['meta_title']) ? $page_init['meta']['meta_title'] : $meta['title'] ?? '';
$author = !empty($page_init['meta']['meta_auther']) ? $page_init['meta']['meta_auther'] : $meta['auther'] ?? 'Log In | Z.com';
$keywords = !empty($page_init['meta']['meta_keywords']) ? $page_init['meta']['meta_keywords'] : $meta['keywords'] ?? '';
$description = !empty($page_init['meta']['meta_description']) ? $page_init['meta']['meta_description'] : $meta['description'] ?? '';
$favicon = $setting->seo_image ?? '';
?>
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no, maximum-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="format-detection" content="telephone=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="mobile-web-app-capable" content="yes">
    <link href="{{ $favicon }}" rel="icon">
    <meta name="theme-color" content="#fff">
    <meta name="author" content="{{ $author }}">
    <meta name="keywords" content="<?php foreach ([$keywords] as $value) {
        echo $value . ', ';
    } ?>">
    <meta name="description" content="{{ $description }}">
    <title>@yield('title', $title)</title>

    <!-- Fonts & Icons -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&family=Noto+Sans+Thai:wght@100..900&family=Roboto:ital,wght@0,100..900;1,100..900&family=STIX+Two+Text:ital,wght@0,400..700;1,400..700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">

    <!-- CSS Plugins -->
    <link href="{{ asset('assets/frontend/css/plugins.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/frontend/css/style.css') }}" rel="stylesheet">

    <!-- jQuery UI CSS -->
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

    <!-- Tailwind CSS -->
    @php
        $manifestPath = public_path('build-frontend/manifest.json');
        $cssFile = null;
        $jsFile = null;
        if (file_exists($manifestPath)) {
            $manifest = json_decode(file_get_contents($manifestPath), true);
            $cssFile = $manifest['resources/assets/sass/app.scss']['file'] ?? null;
            $jsFile = $manifest['resources/assets/js/app.js']['file'] ?? null;
        }
    @endphp
    @if ($cssFile)
        <link rel="stylesheet" href="{{ asset('build-frontend/' . $cssFile) }}">
    @endif
    @if ($jsFile)
        <script type="module" src="{{ asset('build-frontend/' . $jsFile) }}"></script>
    @endif

    <!-- Custom CSS (โหลดหลังสุดเพื่อ override Tailwind ได้) -->
    <link href="{{ asset('assets/frontend/css/custom.css') }}" rel="stylesheet">

    @stack('styles')
</head>

<body class="sh_index">
    <div class="body-inner">
        @include('frontend::layouts.header')

        @yield('content')

        @include('frontend::layouts.footer')
    </div>

    <a id="scrollTop"><i class="icon-chevron-up"></i><i class="icon-chevron-up"></i></a>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- jQuery UI JS -->
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

    <!-- Plugins & Custom JS -->
    <script src="{{ asset('assets/frontend/js/plugins.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/functions.js') }}"></script>
    <script src="{{ asset('assets/frontend/js/custom.js') }}"></script>



    {{-- @include('frontend::layouts.pdpa-popup') --}}

    @stack('scripts')

</body>

</html>
