<div>
    <form wire:submit.prevent="save">
        <div class="row">
            <div class="form-group col-md-6">
                <label for="first-name">{{ __('frontend::lang.contact.first_name') }}</label>
                <input type="text" class="form-control" name="first-name" id="first-name" wire:model="name"
                    placeholder="Enter your first name">
                @error('name')
                    <span class="text-red-500 text-sm px-8 form-style !flex-row c !justify-start">{{ $message }}</span>
                @enderror
            </div>
            <div class="form-group col-md-6">
                <label for="last-name">{{ __('frontend::lang.contact.last_name') }}</label>
                <input type="text" class="form-control" name="last-name" id="last-name" wire:model="lname"
                    placeholder="Enter your last name">
                @error('lname')
                    <span class="text-red-500 text-sm px-8 form-style !flex-row c !justify-start">{{ $message }}</span>
                @enderror
            </div>
        </div>
        <div class="row">
            <div class="form-group col-md-6">
                <label for="email">{{ __('frontend::lang.contact.email') }}</label>
                <input type="email" class="form-control" name="email" id="email" wire:model="email" placeholder="Enter your email">
                @error('email')
                    <span class="text-red-500 text-sm px-8 form-style !flex-row c !justify-start">{{ $message }}</span>
                @enderror
            </div>
            <div class="form-group col-md-6">
                <label for="phone">{{ __('frontend::lang.contact.phone') }}</label>
                <input type="text" class="form-control" name="phone" id="phone" wire:model="tel" placeholder="Enter your phone number">
                @error('tel')
                    <span class="text-red-500 text-sm px-8 form-style !flex-row c !justify-start">{{ $message }}</span>
                @enderror
            </div>
        </div>
        <div class="form-group">
            <label for="subject">{{ __('frontend::lang.contact.subject') }}</label>
            <input type="text" class="form-control" name="subject" id="subject" wire:model="subject" placeholder="Enter the subject">
            @error('subject')
                <span class="text-red-500 text-sm px-8 form-style !flex-row c !justify-start">{{ $message }}</span>
            @enderror
        </div>
        <div class="form-group">
            <label for="message">{{ __('frontend::lang.contact.message') }}</label>
            <textarea class="form-control" name="message" id="message" rows="5" wire:model="msg" placeholder="Enter your message"></textarea>
            @error('msg')
                <span class="text-red-500 text-sm px-8 form-style !flex-row c !justify-start">{{ $message }}</span>
            @enderror
        </div>
        <div class="form-group">
            <div class="custom-control custom-checkbox">
                <input type="checkbox" name="agree" class="custom-control-input" id="agree" wire:model="accept">
                <label class="custom-control-label" for="agree">{{ __('frontend::lang.contact.agree') }} <a
                        href="/privacy">{{ __('frontend::lang.contact.privacy') }}</a></label>
            </div>
            @error('accept')
                <span class="text-red-500 text-sm px-8 form-style !flex-row c !justify-start">{{ $message }}</span>
            @enderror
        </div>
        <div class="form-group">
            <div class="w-full">
                <div class="w-full" id="captcha" wire:ignore></div>
                <input type="hidden" name="recaptcha" id="recaptcha" wire:model="recaptcha"
                    value="{{ $page_init['setting']['recapcha'] ?? '' }}">
            </div>
        </div>
        <button type="submit" class="btn btn-primary btn-block" wire:click="save">{{ __('frontend::lang.contact.send') }}</button>
    </form>
</div>

<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<x-livewire-alert::scripts />
<script src="https://www.google.com/recaptcha/api.js?onload=handle&render=explicit&hl={{ app()->getLocale() }}" async defer></script>
<script>
    var handle = function(e) {
        widget = grecaptcha.render('captcha', {
            'sitekey': document.getElementById("recaptcha").value,
            'theme': 'light',
            'callback': verify
        });
    }
    var verify = function(response) {
        @this.set('captcha', response)
    }

    document.addEventListener('click', function(e) {
        if (e.target && e.target.classList.contains('swal2-confirm')) {
            window.location.reload();
            if (typeof widget !== 'undefined') {
                grecaptcha.reset(widget);
            }
        }
    });
</script>
