<div>
    @livewire('frontend::list-data.request-list', ['page' => 'approval-list'])
    @if (!empty($lists))
        <div id="bulk-action-container" class="p-4 bg-gray-100 border-b border-gray-200">
            <div class="flex items-center space-x-3" x-data="{ selectedCount: 0 }">
                <button type="button"
                    class="px-3 py-3 text-base font-semibold text-white bg-[#801424] rounded-full hover:bg-[#A31D30] focus:outline-none focus:ring-2 focus:ring-[#801424] focus:ring-offset-2 approve-btn transition duration-150 ease-in-out"
                    wire:click="setApproveSelected">อนุมัติทั้งหมดที่เลือก</button>
                <button type="button"
                    class="px-3 py-3 text-base font-semibold text-white bg-red-600 rounded-full hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-offset-2 reject-btn transition duration-150 ease-in-out"
                    wire:click="setRejectSelected">ไม่อนุมัติทั้งหมดที่เลือก</button>
                {{-- หมายเหตุ: ถ้าหน้านี้มองไม่เห็นปุ่ม ให้ตรวจสอบ class "hidden" ที่อยู่ใน <div id="bulk-actions" ...> 
                    ถ้าต้องการให้ปุ่มแสดงผล ให้เอา class "hidden" ออก หรือเปลี่ยนการจัดการแสดง/ซ่อนด้วย Alpine.js, Livewire หรือ JS อื่น ๆ ให้เหมาะสม 
                --}}
                <span class="text-base font-semibold text-white hidden"> 0 รายการที่เลือก</span>
            </div>
        </div>
        <div class="overflow-x-auto shadow-md sm:rounded-lg">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th
                            class="px-2 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider w-10">
                            @php
                                $hasSelectable = false;
                                if (!empty($lists)) {
                                    foreach ($lists as $l) {
                                        if (in_array($status[0], $l['status_all'] ?? [])) {
                                            $hasSelectable = true;
                                            break;
                                        }
                                    }
                                }
                            @endphp
                            @if ($hasSelectable)
                                <input type="checkbox" id="check-all"
                                    class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500"
                                    wire:change="toggleGroupSelection('ALL', $event.target.checked)">
                            @else
                                <span>-</span>
                            @endif
                        </th>
                        <th class="px-6 py-3 text-left text-base font-medium text-dark uppercase tracking-wider">พนักงาน
                            / แผนก</th>
                        <th class="px-6 py-3 text-left text-base font-medium text-dark uppercase tracking-wider">วันที่
                        </th>
                        <th class="px-6 py-3 text-left text-base font-medium text-dark uppercase tracking-wider">
                            สรุปรายการ</th>
                        <th class="px-6 py-3 text-left text-base font-medium text-dark uppercase tracking-wider">สถานะ
                        </th>
                        <th class="px-6 py-3 text-left text-base font-medium text-dark uppercase tracking-wider">
                            การจัดการ</th>
                    </tr>
                </thead>
                <tbody id="approval-table-body" class="bg-white divide-y divide-gray-200">
                    @foreach ($lists as $code => $list)
                        <tr class="main-row hover:bg-gray-50">
                            <td class="px-2 py-4 whitespace-nowrap text-sm text-center">
                                @if (!in_array($status[0], $list['status_all'] ?? []))
                                    <span>-</span>
                                @else
                                    <input type="checkbox" name="approval-item"
                                        class="h-4 w-4 text-blue-600 border-gray-300 rounded approval-checkbox hidden"
                                        wire:change="toggleGroupSelection('{{ $code }}', $event.target.checked)">
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="mr-2 text-gray-400"><i class="bi bi-plus-circle"></i></div>
                                    <div>
                                        <div class="text-sm font-semibold text-white">{{ $list['name'] ?? '' }}</div>
                                        <div class="text-sm text-white">{{ $list['department'] ?? '' }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-white">
                                {{ $list['submission_date'] ?? '' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-white">
                                <div>{{ count($list['request_list']) ?? '' }} รายการ</div>
                                <div class="font-medium text-white">รวม
                                    {{ array_sum(array_column($list['request_list'], 'distance_km')) ?? '' }} กม.</div>
                            </td>
                            
                            <td class="px-6 py-4 whitespace-nowrap text-sm">{!! $list['status'] ?? '' !!}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm space-x-2 action-buttons">
                                <?php
                                if (isset($member) && !empty($list['member_dt']->approve_by_first_id) and $list['member_dt']->approve_by_first_id == $member->id) {
                                    $check_status = 2;
                                } elseif (!empty($list['member_dt']->approve_by_second_id) and $list['member_dt']->approve_by_second_id == $member->id) {
                                    $check_status = 3;
                                } else {
                                    $check_status = 0;
                                }
                                ?>
                                @if (in_array($check_status, $list['status_all'] ?? []))
                                    <button type="button"
                                        class="inline-flex items-center px-3 lg:px-3 py-1.5 border border-transparent text-base font-medium rounded-full shadow-sm text-white bg-[#801424] hover:bg-[#a63a49] focus:ring-[#801424] focus:ring-2 focus:ring-offset-2 focus:ring-red-500 {{ $approve_btn_list ? 'opacity-50 cursor-not-allowed' : '' }} approve-btn"
                                        wire:click="setApprove('{{ $code }}')"
                                        {{ $approve_btn_list ? 'disabled' : '' }}>อนุมัติ</button>
                                    <button type="button"
                                        class="inline-flex items-center px-3 lg:px-3 py-1.5 border border-transparent text-base font-medium rounded-full shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 {{ $reject_btn_list ? 'opacity-50 cursor-not-allowed' : '' }} reject-btn"
                                        wire:click="openRejectModal('{{ $code }}')"  {{ $reject_btn_list ? 'disabled' : '' }}>ปฏิเสธ</button>
                                @endif
                            </td>
                        </tr>
                        {{-- Detail Row --}}
                        <tr class="details-row bg-gray-50"
                            style="display: {{ $tab_details_row ? 'table-row;' : 'none;' }}">
                            <td colspan="6" class="p-0">
                                <div class="p-4">
                                    <table class="min-w-full divide-y divide-gray-200 border border-gray-200">
                                        <thead class="bg-gray-200">
                                            <tr>
                                                <th
                                                    class="px-3 py-2 text-center text-base font-medium text-dark uppercase tracking-wider">
                                                    เลือก</th>
                                                <th
                                                    class="px-3 py-2 text-center text-base font-medium text-dark uppercase tracking-wider">
                                                    สถานะคำขอ</th>
                                                <th
                                                    class="px-3 py-2 text-center text-base font-medium text-dark uppercase tracking-wider">
                                                    สถานที่ปัจจุบัน</th>
                                                <th
                                                    class="px-3 py-2 text-center text-base font-medium text-dark uppercase tracking-wider">
                                                    สถานที่ไป</th>
                                                <th
                                                    class="px-3 py-2 text-center text-base font-medium text-dark uppercase tracking-wider">
                                                    เวลา <br>Check-in/out</th>
                                                <th
                                                    class="px-3 py-2 text-center text-base font-medium text-dark uppercase tracking-wider">
                                                    ระยะทาง</th>
                                                <th
                                                    class="px-3 py-2 text-center text-base font-medium text-dark uppercase tracking-wider">
                                                    ค่าน้ำมัน</th>
                                                <th
                                                    class="px-3 py-2 text-center text-base font-medium text-dark uppercase tracking-wider">
                                                    สถานะ</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            @if (!empty($list['request_list']))
                                                @foreach ($list['request_list'] as $request)
                                                    <tr>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm">
                                                            @if ($request['status_id'] === $status[0])
                                                                <input type="checkbox" name="approval-detail-item"
                                                                    class="h-4 w-4 text-blue-600 border-gray-300 rounded"
                                                                    value="{{ $request['id'] }}"
                                                                    wire:change="toggleSingleItem({{ $request['id'] }}, $event.target.checked)">
                                                            @else
                                                                <span>-</span>
                                                            @endif
                                                        </td>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-dark">
                                                            {{ $request['status_request'] ?? '' }}</td>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-dark">
                                                            {{ $request['current_place'] ?? '' }}</td>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-dark">
                                                            {{ $request['target_place'] ?? '' }}</td>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-dark">
                                                            {{ $request['time'] ?? '' }} -
                                                            {{ $request['checkout_time'] ?? '' }} น.</td>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-dark">
                                                            {{ $request['distance_km'] ?? '' }}</td>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm text-dark">
                                                            {{ $request['oil_price'] ?? '' }}</td>
                                                        <td class="px-3 py-2 whitespace-nowrap text-sm">
                                                            {!! $request['status'] ?? '' !!}</span></td>
                                                    </tr>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        @if ($confirm_open)
            <div class="fixed inset-0 bg-gray-600 bg-opacity-75 overflow-y-auto h-full w-full z-[100] flex items-center justify-center"
                id="approvalConfirmModal">
                <div class="bg-white rounded-lg shadow-xl w-full max-w-md m-4 z-[101]">
                    <div class="flex justify-between items-center p-2 border-b">
                        <h5 class="text-base font-semibold text-gray-900">
                            @if (in_array($confirm_action_type, ['reject', 'reject_selected']))
                                ยืนยันการปฏิเสธ
                            @else
                                แจ้งเตือน
                            @endif
                        </h5>
                        <button type="button" class="text-gray-400 hover:text-gray-600 focus:outline-none"
                            wire:click="closeConfirm" aria-label="Close">
                        </button>
                    </div>
                    <div class="pl-0 pr-0 {{ (isset($no_checkbox_selected) && $no_checkbox_selected) ? "pt-4" : "p-5 " }} ">
                        <p class="text-gray-700 text-left font-medium text-base {{ (isset($no_checkbox_selected) && $no_checkbox_selected) ? "border-b pb-4" : " " }}  pl-3">
                            {{-- เงื่อนไข: ถ้าไม่มีการเลือก checkbox เลย (เลือกได้อย่างน้อย 1 รายการเท่านั้น) --}}
                            @if (isset($no_checkbox_selected) && $no_checkbox_selected)
                                <span class="text-gray-500 text-left block">กรุณาเลือกอย่างน้อย 1 รายการ</span>
                            @else
                                @if (in_array($confirm_action_type, ['reject', 'reject_selected']))
                                    <div class="p-6 ">
                                        <label for="remarks-textarea"
                                            class="block text-sm font-medium text-gray-700">เหตุผลการปฏิเสธ <span
                                                class="text-red-500">*</span></label>
                                        <textarea wire:model.live="remarks" id="remarks-textarea"
                                            class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                            rows="5" placeholder="กรุณาระบุเหตุผลการปฏิเสธ..." autofocus>
                                    </textarea>
                                        <div class="mt-2">
                                            <small class="text-sm">
                                                @if (strlen($remarks) > 0)
                                                    <span class="text-green-600">✓ {{ strlen($remarks) }}
                                                        ตัวอักษร</span>
                                                @else
                                                    <span class="text-red-500">⚠ กรุณากรอกเหตุผล</span>
                                                @endif
                                            </small>
                                        </div>
                                    </div>
                                @else
                                    ต้องการอนุมัติรายการนี้หรือไม่?
                                @endif
                            @endif
                        </p>

                        {{-- ถ้าไม่มี checkbox ให้เลือก และ $confirm_action_type เป็น approve/reject selected --}}
                        @if (isset($no_checkbox_selected) && $no_checkbox_selected)
                            <div class="flex justify-end mt-6 text-left py-2">
                                <button type="button"
                                    class="px-4 py-2 text-sm font-medium text-white bg-[#801424] border border-gray-300 rounded-full shadow-sm hover:bg-[#A31D30] focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#801424] float-right m-5"
                                    wire:click="closeConfirm">ยกเลิก</button>
                            </div>
                        @else
                            <div class="px-6 py-4 bg-gray-50 flex justify-end space-x-3 rounded-b-lg mt-4">
                                <button type="button"
                                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-full shadow-sm hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                                    wire:click="closeConfirm">ยกเลิก</button>
                                <button type="button" id="confirmModalBtn"
                                    class="px-4 py-2 text-sm font-medium text-white rounded-full text-white shadow-sm focus:outline-none focus:ring-2 focus:ring-offset-2 bg-[#801424] hover:bg-[#A31D30] focus:ring-[#801424]>
                                    @if (in_array($confirm_action_type, ['reject', 'reject_selected'])) bg-[#801424] hover:bg-[#A31D30] focus:ring-[#801424]
                                    @else
                                        bg-[#801424] hover:bg-[#A31D30] focus:ring-[#801424] @endif"
                                    wire:click="confirmAction">
                                    @if (in_array($confirm_action_type, ['reject', 'reject_selected']))
                                        ปฏิเสธ
                                    @else
                                        อนุมัติ
                                    @endif
                                </button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        @endif

        @if ($show_reject_modal)
            <div class="fixed inset-0 bg-gray-600 bg-opacity-75 overflow-y-auto h-full w-full z-[110] flex items-center justify-center"
                id="rejectModal">
                <div class="bg-white rounded-lg shadow-xl w-full max-w-lg m-4 z-[111]">
                    <div class="flex justify-between items-center p-6 border-b">
                        <h5 class="text-base font-semibold text-gray-900">ยืนยันการปฏิเสธ</h5>
                        <button type="button" class="text-gray-400 hover:text-dark focus:outline-none"
                            wire:click="closeRejectModal" aria-label="Close">
                            <span class="sr-only">Close</span>
                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>
                    <div class="p-6">
                        <label for="rejectReason" class="block text-sm font-medium text-gray-700">กรอกเหตุผล: <span
                                class="text-red-500">*</span></label>
                        <textarea id="rejectReason" wire:model.live="remarks" rows="5"
                            class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 focus:ring-red-500 focus:border-red-500 sm:text-sm"
                            placeholder="ระบุเหตุผลในการปฏิเสธ..."></textarea>
                        <div class="mt-2">
                            @if (!empty($remarks))
                                <small class="text-sm text-green-600">✓ {{ strlen($remarks) }} ตัวอักษร</small>
                            @else
                                <small class="text-sm text-red-500">⚠ กรุณากรอกเหตุผล</small>
                            @endif
                        </div>
                    </div>
                    <div class="px-6 py-4 bg-gray-50 flex justify-end space-x-3 rounded-b-lg">
                        <button type="button"
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-full shadow-sm hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                            wire:click="closeRejectModal">ยกเลิก</button>
                        <button type="button"
                            class="px-4 py-2 text-sm font-medium text-white bg-red-600 border border-transparent rounded-full shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500"
                            wire:click="submitReject">ปฏิเสธ</button>
                    </div>
                </div>
            </div>
        @endif


        <div class="p-4">
            <x-frontend::pagination :currentPage="$cur_page" :totalPages="$page_total" :pages=$pages :opt=$per_page />
        </div>
    @endif
</div>

<script>
    // ใช้ event delegation เพื่อให้ทำงานได้แม้หลัง Livewire re-render
    document.addEventListener('change', function(e) {
        // เมื่อคลิก check-all checkbox
        if (e.target && e.target.id === 'check-all') {
            const isChecked = e.target.checked;

            // Check/uncheck checkbox ทั้งหมดทันที
            const approvalCheckboxes = document.querySelectorAll('input[name="approval-item"]');
            const detailCheckboxes = document.querySelectorAll('input[name="approval-detail-item"]');

            approvalCheckboxes.forEach(function(checkbox) {
                checkbox.checked = isChecked;
            });

            detailCheckboxes.forEach(function(checkbox) {
                checkbox.checked = isChecked;
            });
        }
    });

    // Sync check-all state หลังจาก Livewire update
    if (typeof Livewire !== 'undefined') {
        Livewire.hook('message.processed', (message, component) => {
            // รอให้ DOM อัพเดทเสร็จ
            setTimeout(function() {
                const checkAll = document.getElementById('check-all');
                const approvalCheckboxes = document.querySelectorAll('input[name="approval-item"]');

                if (checkAll && approvalCheckboxes.length > 0) {
                    // ตรวจสอบว่าทุก checkbox ถูก checked หรือไม่
                    const allChecked = Array.from(approvalCheckboxes).every(function(cb) {
                        return cb.checked;
                    });
                    checkAll.checked = allChecked;
                }
            }, 100);
        });
    }
</script>
