<div>
    <!-- ส่วนที่ 1: ข้อมูลส่วนตัว -->
    <x-frontend::member-info-card :member="$member" />

    <!-- ตารางประวัติ -->
    <div class="card">
        <div class="sm:pb-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 items-center">
                <div>
                    <p class="sm:text-xl md:text-2xl font-bold">ข้อมูลประวัติการเดินทาง</p>
                </div>
                <div class="flex justify-end w-full md:w-auto col-span-1 md:col-span-auto">
                    <button onclick="exportPDF('{{ $start_date }}', '{{ $end_date }}')"
                        class="bg-danger hover:bg-danger-dark text-white font-bold py-2 px-4 rounded flex items-center text-white">
                        <img src="{{ Module::asset('frontend:img/icons/export-excel.png') }}" alt="Export Excel" class="mr-2" style="height: 1.25em;">
                        Export PDF
                    </button>
                </div>
            </div>
        </div>
        <div class="flex justify-center">
            <div class="w-full max-w-3xl">
                <form wire:submit.prevent="filterHistory" class="grid grid-cols-1 gap-2 sm:grid-cols-3">
                    <div class="filter-group pb-2 sm:pb-0 flex flex-col sm:col-span-1 w-full">
                        <label class="mb-1">จาก:</label>
                        <input type="datetime-local" wire:model="start_date" class="form-control w-full" />
                    </div>
                    <div class="filter-group pb-2 sm:pb-0 flex flex-col sm:col-span-1 w-full">
                        <label class="mb-1 pl-0 sm:pl-2">ถึง:</label>
                        <input type="datetime-local" wire:model="end_date" class="form-control w-full" />
                    </div>
                    <div class="filter-group pb-2 sm:pb-0 flex flex-col sm:col-span-1 w-full">
                        <label class="mb-1 pl-0 sm:pl-2">&nbsp;</label>
                        <button type="submit" class="btn btn-search flex items-center justify-center">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <form action="" wire:submit.prevent="sendReport">
            <div class="overflow-x-auto">
                <table border="1" cellpadding="6" cellspacing="0" class="history-table min-w-full text-sm sm:text-base">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="px-2 py-2 whitespace-nowrap text-center">
                                <div class="flex flex-col items-center">
                                    {{-- <input type="checkbox" id="checkAll" onclick="toggleSelectAll(this)" class="mx-auto mb-1"> --}}
                                    <span class="block font-semibold">ลำดับ</span>
                                </div>
                            </th>
                            <th class="px-2 py-2 whitespace-nowrap">วันที่</th>
                            <th class="px-2 py-2 whitespace-nowrap">เวลา Check-in</th>
                            <th class="px-2 py-2 whitespace-nowrap">เวลา Check-out</th>
                            <th class="px-2 py-2 whitespace-nowrap">สถานที่ปัจจุบัน</th>
                            <th class="px-2 py-2 whitespace-nowrap">สถานที่จะไป</th>
                            <th class="px-2 py-2 whitespace-nowrap">ระยะทาง (กม.)</th>
                            <th class="px-2 py-2 whitespace-nowrap">ค่าน้ำมัน (บาท)</th>
                            <th class="px-2 py-2 whitespace-nowrap">สถานะ</th>
                        </tr>
                    </thead>
                    <tbody id="history-body">
                        <!-- ตัวอย่างข้อมูล -->
                        @if (!empty($list))
                            @foreach ($list as $i => $item)
                                <tr>
                                    <td class="px-2 py-1 text-center">
                                        {{ $i+1 }}
                                        {{-- @if ($item->status == 1 and !empty($item->checkout_time))
                                            <input type="checkbox" wire:model="selected_rows" value="{{ $item->id }}"
                                                class="row-checkbox">
                                        @else
                                            <span>-</span>
                                        @endif --}}
                                    </td>
                                    <td class="px-2 py-1 text-center">{{ $item->created_at->format('d/m/Y') }}</td>
                                    <td class="px-2 py-1 text-center">{{ $item->time->format('H:i') }}</td>
                                    <td class="px-2 py-1 text-center">
                                        @if ($item->checkout_time)
                                            {{ $item->checkout_time->format('H:i') }}
                                        @elseif ($item->created_at->isToday())
                                            กำลังทำงาน
                                        @else
                                            &nbsp;
                                        @endif
                                    </td>
                                    <td class="px-2 py-1">{{ $item->current_place }}</td>
                                    <td class="px-2 py-1">{{ $item->target_place }}</td>
                                    <td class="px-2 py-1 text-center">{{ $item->distance_km }}</td>
                                    <td class="px-2 py-1 text-center">{{ $item->oil_price ?? 0 }}</td>
                                    <td class="px-2 py-1 text-center">
                                        @if ($item->status == 1 and !empty($item->checkout_time))
                                            รอส่งข้อมูล
                                        @elseif ($item->status == 2)
                                            รออนุมัติ
                                        @elseif ($item->status == 3)
                                            รออนุมัติ
                                        @elseif ($item->status == 4)
                                            อนุมัติ
                                        @elseif ($item->status == 13)
                                            ไม่อนุมัติ
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="9" class="text-center py-3">ไม่มีข้อมูล</td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            {{-- <div class="action-container mt-4 flex flex-row justify-end items-center">
                <button type="submit" class="btn btn-send w-full sm:w-auto">
                    📤 ส่งข้อมูลรายงานการเดินทาง
                </button>
            </div> --}}
        </form>
    </div>
</div>
<script>
    function toggleSelectAll(checkbox) {
        const checkboxes = document.querySelectorAll('.row-checkbox');
        checkboxes.forEach(box => {
            box.checked = checkbox.checked;
            // Trigger Livewire event
            box.dispatchEvent(new Event('change', {
                bubbles: true
            }));
        });
    }

    // Listen for Livewire alert events
    document.addEventListener('livewire:init', () => {
        Livewire.on('alert', (event) => {
            const data = event[0] || event;
            Swal.fire({
                title: data.title || 'แจ้งเตือน',
                icon: data.type || 'info',
                confirmButtonText: 'ตกลง'
            });
        });
    });
</script>
