@extends('frontend::layouts.applogin')

@section('content')
  <!-- Livewire Login Component -->
  @livewire('frontend::login-form')
@endsection

@push('scripts')
@if(session('success'))
<script>
  document.addEventListener('DOMContentLoaded', function() {
    Swal.fire({
      icon: 'success',
      title: 'สำเร็จ!',
      html: '{{ session('success') }}',
      confirmButtonText: 'ตกลง',
      confirmButtonColor: '#28a745',
      showClass: {
        popup: 'animate__animated animate__fadeInDown'
      },
      hideClass: {
        popup: 'animate__animated animate__fadeOutUp'
      }
    });
  });
</script>
@endif

@if(session('error'))
<script>
  document.addEventListener('DOMContentLoaded', function() {
    Swal.fire({
      icon: 'error',
      title: 'เกิดข้อผิดพลาด',
      html: '{{ session('error') }}',
      confirmButtonText: 'ตกลง',
      confirmButtonColor: '#e60303',
      showClass: {
        popup: 'animate__animated animate__fadeInDown'
      },
      hideClass: {
        popup: 'animate__animated animate__fadeOutUp'
      }
    });
  });
</script>
@endif
@endpush