@extends('frontend::layouts.app')

@section('content')
    @livewire('frontend::form.checkin', ['member' => $member,'type' => 'recorddatamanager'])

    <!-- Modal บันทึกสำเร็จ -->
    <div id="checkoutModal" class="hidden modal-overlay">
        <div class="modal-content">
            <button id="closeModal" class="modal-close-btn">✕</button>
            <div class="modal-icon-success">✔️</div>
            <h2 class="modal-title">บันทึก Check-out เรียบร้อย</h2>
            <div class="modal-button-container">
                <button id="modalConfirm" class="modal-btn-confirm">ปิด</button>
            </div>
        </div>
    </div>

    <!-- Modal แจ้งตำแหน่งไม่สำเร็จ -->
    <div id="locationModal" class="hidden modal-overlay">
        <div class="modal-content">
            <button id="closeLocationModal" class="modal-close-btn">✕</button>
            <div class="modal-icon-error">⚠️</div>
            <h2 id="locationModalMessage" class="modal-title-small">ไม่สามารถดึงตำแหน่งได้</h2>
            <div class="modal-button-container">
                <button id="locationModalOk" class="modal-btn-confirm">ปิด</button>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <link rel="stylesheet" href="{{ asset('modules/frontend/assets/css/recorddatamanager.css') }}">
@endpush

@push('scripts')
    <script src="{{ asset('modules/frontend/assets/js/recorddata.js') }}"></script>
    <script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCsTYM_vFrL0PuZ9cCVH3iAv3eWvsQmmpU&libraries=places&callback=initAutocomplete"
        async defer></script>
@endpush
