<?php

namespace Modules\Map\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Member\app\Models\Member;
use Modules\Map\Database\factories\CheckInOutFactory;

class CheckInOut extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = ['member_id','code_req', 'type', 'type', 'place', 'lat', 'lng', 'time', 'address', 'checkout_lat', 'checkout_lng', 'checkout_time', 'checkout_address', 'distance_km', 'oil_price','current_place', 'target_place', 'reason', 'status_request', 'status','submission_date','remarks'];

    protected $table = 'check_in_out';
    protected $primaryKey = 'id';

    protected $casts = [
        'time' => 'datetime',
        'checkout_time' => 'datetime',
        'status_request' => 'array',
        'code_req' => 'string',
        'submission_date' => 'datetime',
    ];

    protected static function newFactory(): CheckInOutFactory
    {
        //return CheckInOutFactory::new();
    }

    public function member()
    {
        return $this->belongsTo(Member::class, 'member_id', 'id');
    }
}
