<?php

namespace Modules\Member\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Map\app\Models\CheckInOut;
use Modules\Member\app\Models\Member;

class MemberController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('member::index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('member::create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): RedirectResponse
    {
        //
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        return view('member::show');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        return view('member::edit');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id): RedirectResponse
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
    }


    public static function CountItems($member_id)
    {
        /**
         * ต้องการดึง "ข้อมูลรอการอนุมัติ" โดย:
         *  - ถ้าเราเป็นผู้อนุมัติคนที่ 1  -> ดูรายการของลูกน้องที่มีเราเป็น approve_by_first_id และ status = 2
         *  - ถ้าเราเป็นผู้อนุมัติคนที่ 2  -> ดูรายการของลูกน้องที่มีเราเป็น approve_by_second_id และ status = 3
         *  - ไม่สนใจ lavel_id
         */
        $count = 0;
        // หา member ที่เราเป็นคนอนุมัติลำดับที่ 1 หรือ 2
        $member_first_ids  = Member::where('approve_by_first_id', $member_id)->pluck('id')->toArray();
        $member_second_ids = Member::where('approve_by_second_id', $member_id)->pluck('id')->toArray();

        $member_ids = [];
        $statusFilter = [];

        // กำหนดบทบาทหลักของผู้ใช้ปัจจุบัน และสถานะที่ต้องดู
        $hasFirst  = !empty($member_first_ids);
        $hasSecond = !empty($member_second_ids);

        // Note: The original code used 'break;' outside of loop/switch, which is invalid in PHP
        // Fix: Simply use if/elseif/else block, no breaks

        if ($hasFirst && !$hasSecond) {
            // เป็นเฉพาะผู้อนุมัติลำดับที่ 1 -> ดู status = 2 ของลูกน้องที่เราเป็น approve_by_first_id
            $member_ids   = $member_first_ids;
            $statusFilter = [2];
        } elseif (!$hasFirst && $hasSecond) {
            // เป็นเฉพาะผู้อนุมัติลำดับที่ 2 -> ดู status = 3 ของลูกน้องที่เราเป็น approve_by_second_id
            $member_ids   = $member_second_ids;
            $statusFilter = [3];
        } elseif ($hasSecond) {
            // มีทั้งสองบทบาท ให้ถือว่าเป็นผู้อนุมัติลำดับที่ 2 เป็นหลัก
            $member_ids   = $member_second_ids;
            $statusFilter = [3];
        } else {
            return collect();
        }

        // unique member id
        $member_ids = array_values(array_unique($member_ids));

        // นับจำนวน code_req ที่ไม่ซ้ำกัน
        $count = CheckInOut::whereIn('member_id', $member_ids)
            ->whereIn('status', $statusFilter)
            ->distinct()
            ->count('code_req');
        return $count;
    }
}
