<?php

namespace Modules\Member\app\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Route;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Member\app\Models\Member;

class MemberSettingAdminController extends AdminController
{
    private $module, $method, $action, $config;

    /**
     * Function : construct
     * Dev : Wan
     * Update Date : 22 Jan 2025
     */
    public function __construct()
    {
        $routeName = Route::currentRouteName();
		if ($routeName) {
			$explode = explode('.', $routeName);
			$this->module = $explode[1] ?? '';
			$this->method = $explode[2] ?? '';
			$this->action = $explode[3] ?? '';
		} else {
			$this->module = '';
			$this->method = '';
			$this->action = '';
		}

        self::$navbar = [
            ['name' => __("member::setting.{$this->module}.title"), 'url' => null],
            ['name' => __("member::setting.{$this->module}.name"), 'url' => route_has("admin.{$this->module}.{$this->method}.index")]
        ];
        $this->config = config("member.setting.{$this->module}");
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('member::setting.form', [
            'navbar' => self::$navbar,
            'config' => $this->config,
            'method' => $this->method,
            'type' => $this->module,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('member::create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): RedirectResponse
    {
        //
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        return view('member::show');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        return view('member::edit');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id): RedirectResponse
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        //
    }

    /**
     * Generate or re-run employee codes with prefix and padding.
     * Request params: prefix (string), padding (int)
     */
    public function run_code(Request $request)
    {
        $prefix = (string) $request->get('prefix', 'EMP');
        $padding = (int) $request->get('padding', 5);
        if ($padding < 1 || $padding > 10) $padding = 5;

        $members = Member::orderBy('id')->get(['id','code']);
        $updated = 0;
        $seq = 1;
        foreach ($members as $m) {
            $newCode = $prefix . str_pad((string)$seq, $padding, '0', STR_PAD_LEFT);
            if ($m->code !== $newCode) {
                $m->code = $newCode;
                $m->save();
                $updated++;
            }
            $seq++;
        }

        return self::response(['msg' => __('noti.success'), 'updated' => $updated]);
    }
}
