<?php

namespace Modules\Member\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Member\app\Models\Member;
use Modules\Member\app\Models\MemberTimelineLang;
use Modules\Member\Database\factories\MemberTimelineFactory;

class MemberTimeline extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     * Current location in English
     */
    // สถานที่ปัจจุบัน,สถานที่จะไป
    protected $fillable = [
        'member_id',
        'location',
        'location_to',
        'distance', // ระยะทาง (กม.)
        'oil_cost', // ค่าน้ำมัน (บาท)
        'date',
        'time',
        'status_request',
        'status',
        'sort',
        'created_at',
        'updated_at'
    ];

    protected $table = 'member_timeline';
    protected $primaryKey = 'id';

    protected static function newFactory(): MemberTimelineFactory
    {
        //return MemberTimelineFactory::new();
    }

    public function member()
    {
        return $this->belongsTo(Member::class, 'member_id', 'id');
    }
}
