<?php

return [
	'member' => [
		'member' => [
			'table' => [
				'header' => [
					['title' => __('field.image'), 'column' => 'image', 'orderable' => false, 'class' => 'text-center', 'status' => false],
					['title' => __('field.code'), 'column' => 'code', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => __('field.name'), 'column' => 'name', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => __('field.email'), 'column' => 'email', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => __('field.department'), 'column' => 'department', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => __('field.position'), 'column' => 'position', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => __('member::member.form.parent'), 'column' => 'parent_id', 'orderable' => false, 'class' => '', 'status' => false],
					['title' => __('member::lavel.member.name'), 'column' => 'lavel_id', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => __('field.publish'), 'column' => 'publish_at', 'orderable' => false, 'class' => '', 'status' => false],
					['title' => __('field.view'), 'column' => 'view', 'orderable' => false, 'class' => '', 'status' => false],
				],
				'filter' => [
					'lavel_id' => ['type' => 'select', 'url' => 'admin.member.lavel.get_list', 'status' => true,'label' => __('member::lavel.member.name')],
					'parent_id' => ['type' => 'select', 'url' => 'admin.member.manage.get_list', 'status' => true,'label' => __('member::member.form.parent')],
				],
				'btn' => [
					'add' => true,
					'sort' => false,
					'default' => false,
					'status' => true,
					'edit' => true,
					'delete' => true,
					'export' => true,
					'excel' => true,
					'pdf' => false,
					'email' => true,
					'view_more' => true,
				],
			],
			'form' => [
				'navbar' => [
					'translate' => [
						'status' => true,
						'input' => [
							'code' => ['type' => 'input', 'status' => true, 'validate' => true],
							'name' => ['type' => 'input', 'status' => true, 'validate' => true],
							// 'password' => ['type' => 'hidden', 'status' => true, 'validate' => false],
							// 'confirm_password' => ['type' => 'hidden', 'status' => true, 'validate' => false],
							'email' => ['type' => 'email', 'status' => true, 'validate' => true],
							'department' => ['type' => 'input', 'status' => true, 'validate' => false],
							'position' => ['type' => 'input', 'status' => true, 'validate' => false],
						],
					],
					'other' => [
						'status' => false,
						'input' => [
							'categories' => ['type' => 'multiple', 'status' => false, 'validate' => false, 'url' => 'admin.products.content.get_category_list', 'max' => 10],
							'related' => ['type' => 'multiple', 'status' => false, 'validate' => false, 'url' => 'admin.products.content.get_list', 'max' => 100],
						],
					],
					'upload' => [
						'status' => false,
						'input' => [
							'gallery' => ['type' => 'gallery', 'status' => false, 'label' => __('field.gallery'), 'max' => '8', 'accept' => 'image/*', 'recommend' => __('field.products.image_recommend')],
							'image' => ['type' => 'upload_image', 'status' => false, 'label' => __('field.image'), 'recommend' => __('field.image_recommend'), 'size' => ''],
							'video' => ['type' => 'upload_video', 'status' => false, 'label' => __('field.video'), 'recommend' => __('field.video_recommend')],
							'youtube' => ['type' => 'input', 'status' => false],
							'file' => ['type' => 'upload_file', 'status' => false, 'label' => __('field.file'), 'recommend' => __('field.file_recommend')],
						],
					],
					'seo' => [
						'status' => false,
					],
				],
				'sidebar' => [
					'lang' => [
						'status' => true,
					],
					'setting' => [
						'status' => true,
						'input' => [
							'lavel_id' => ['type' => 'select', 'status' => true, 'validate' => true, 'url' => 'admin.member.lavel.get_list','label' => __('member::lavel.member.name'),'placeholder' => __('member::lavel.member.lavel_placeholder')],
							'publish_at' => ['type' => 'icon', 'status' => false, 'validate' => false, 'class' => 'datetime-picker', 'icon' => 'fe-calendar'],
							'period' => ['type' => 'icon', 'status' => false, 'validate' => false, 'class' => 'range-picker', 'icon' => 'fe-calendar', 'start' => 'start_at', 'end' => 'end_at'],
							'time' => ['type' => 'time', 'status' => false, 'validate' => false, 'class' => 'time-picker', 'icon' => 'fe-calendar', 'start' => 'start_time', 'end' => 'end_time'],
							'link' => ['type' => 'input', 'status' => false, 'validate' => false],
							'parent_id' => ['type' => 'select', 'status' => false, 'validate' => false, 'url' => 'admin.member.manage.get_list', 'label' => __('member::member.form.parent'),'placeholder' => __('member::member.form.parent_placeholder')],
							'approve_by_first' => ['type' => 'select', 'status' => true, 'validate' => false, 'url' => 'admin.member.member.get_list', 'label' => __('member::member.form.approve_by_first'),'placeholder' => __('member::member.form.approve_by_first_placeholder')],
							'approve_by_second' => ['type' => 'select', 'status' => true, 'validate' => false, 'url' => 'admin.member.member.get_list', 'label' => __('member::member.form.approve_by_second'),'placeholder' => __('member::member.form.approve_by_second_placeholder')],
							'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
							'default' => ['type' => 'checkbox', 'status' => false, 'validate' => false],
							
						],
					]
				],
			],
		],
	],

	'lavel' => [
		'member' => [
			'table' => [
				'header' => [
					['title' => __('field.image'), 'column' => 'image', 'orderable' => false, 'class' => 'text-center', 'status' => false],
					['title' => __('field.name'), 'column' => 'name', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => __('field.publish'), 'column' => 'publish_at', 'orderable' => false, 'class' => '', 'status' => false],
					['title' => __('field.view'), 'column' => 'view', 'orderable' => false, 'class' => '', 'status' => false],
				],
				'filter' => [
					'category_id' => ['type' => 'select', 'url' => 'admin.products.content.get_category_list', 'status' => false],
				],
				'btn' => [
					'add' => false,
					'sort' => true,
					'default' => false,
					'status' => true,
					'edit' => true,
					'delete' => false,
				],
			],
			'form' => [
				'navbar' => [
					'translate' => [
						'status' => true,
						'input' => [
							'name' => ['type' => 'input', 'status' => true, 'validate' => true],
						],
					],
					'other' => [
						'status' => false,
						'input' => [
							'categories' => ['type' => 'multiple', 'status' => false, 'validate' => false, 'url' => 'admin.products.content.get_category_list', 'max' => 10],
							'related' => ['type' => 'multiple', 'status' => false, 'validate' => false, 'url' => 'admin.products.content.get_list', 'max' => 100],
						],
					],
					'upload' => [
						'status' => false,
						'input' => [
							'gallery' => ['type' => 'gallery', 'status' => false, 'label' => __('field.gallery'), 'max' => '8', 'accept' => 'image/*', 'recommend' => __('field.products.image_recommend')],
							'image' => ['type' => 'upload_image', 'status' => false, 'label' => __('field.image'), 'recommend' => __('field.image_recommend'), 'size' => ''],
							'video' => ['type' => 'upload_video', 'status' => false, 'label' => __('field.video'), 'recommend' => __('field.video_recommend')],
							'youtube' => ['type' => 'input', 'status' => false],
							'file' => ['type' => 'upload_file', 'status' => false, 'label' => __('field.file'), 'recommend' => __('field.file_recommend')],
						],
					],
					'seo' => [
						'status' => false,
					],
				],
				'sidebar' => [
					'lang' => [
						'status' => true,
					],
					'setting' => [
						'status' => true,
						'input' => [
							'categories' => ['type' => 'multiple', 'status' => false, 'validate' => true, 'url' => 'admin.products.category.get_list'],
							'publish_at' => ['type' => 'icon', 'status' => false, 'validate' => false, 'class' => 'datetime-picker', 'icon' => 'fe-calendar'],
							'period' => ['type' => 'icon', 'status' => false, 'validate' => false, 'class' => 'range-picker', 'icon' => 'fe-calendar', 'start' => 'start_at', 'end' => 'end_at'],
							'time' => ['type' => 'time', 'status' => false, 'validate' => false, 'class' => 'time-picker', 'icon' => 'fe-calendar', 'start' => 'start_time', 'end' => 'end_time'],
							'link' => ['type' => 'input', 'status' => false, 'validate' => false],
							'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
							'default' => ['type' => 'checkbox', 'status' => false, 'validate' => false],
						],
					]
				],
			],
		],
	],

	'manage' => [
		'member' => [
			'table' => [
				'header' => [
					['title' => __('field.image'), 'column' => 'image', 'orderable' => false, 'class' => 'text-center', 'status' => false],
					['title' => __('field.name'), 'column' => 'name', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => __('field.publish'), 'column' => 'publish_at', 'orderable' => false, 'class' => '', 'status' => false],
					['title' => __('field.view'), 'column' => 'view', 'orderable' => false, 'class' => '', 'status' => false],
				],
				'filter' => [
					'category_id' => ['type' => 'select', 'url' => 'admin.products.content.get_category_list', 'status' => false],
				],
				'btn' => [
					'add' => true,
					'sort' => true,
					'default' => false,
					'status' => true,
					'edit' => true,
					'delete' => true,
				],
			],
			'form' => [
				'navbar' => [
					'translate' => [
						'status' => true,
						'input' => [
							'name' => ['type' => 'input', 'status' => true, 'validate' => true],
						],
					],
					'other' => [
						'status' => false,
						'input' => [
							'categories' => ['type' => 'multiple', 'status' => false, 'validate' => false, 'url' => 'admin.products.content.get_category_list', 'max' => 10],
							'related' => ['type' => 'multiple', 'status' => false, 'validate' => false, 'url' => 'admin.products.content.get_list', 'max' => 100],
						],
					],
					'upload' => [
						'status' => false,
						'input' => [
							'gallery' => ['type' => 'gallery', 'status' => false, 'label' => __('field.gallery'), 'max' => '8', 'accept' => 'image/*', 'recommend' => __('field.products.image_recommend')],
							'image' => ['type' => 'upload_image', 'status' => false, 'label' => __('field.image'), 'recommend' => __('field.image_recommend'), 'size' => ''],
							'video' => ['type' => 'upload_video', 'status' => false, 'label' => __('field.video'), 'recommend' => __('field.video_recommend')],
							'youtube' => ['type' => 'input', 'status' => false],
							'file' => ['type' => 'upload_file', 'status' => false, 'label' => __('field.file'), 'recommend' => __('field.file_recommend')],
						],
					],
					'seo' => [
						'status' => false,
					],
				],
				'sidebar' => [
					'lang' => [
						'status' => true,
					],
					'setting' => [
						'status' => true,
						'input' => [
							'categories' => ['type' => 'multiple', 'status' => false, 'validate' => true, 'url' => 'admin.products.category.get_list'],
							'publish_at' => ['type' => 'icon', 'status' => false, 'validate' => false, 'class' => 'datetime-picker', 'icon' => 'fe-calendar'],
							'period' => ['type' => 'icon', 'status' => false, 'validate' => false, 'class' => 'range-picker', 'icon' => 'fe-calendar', 'start' => 'start_at', 'end' => 'end_at'],
							'time' => ['type' => 'time', 'status' => false, 'validate' => false, 'class' => 'time-picker', 'icon' => 'fe-calendar', 'start' => 'start_time', 'end' => 'end_time'],
							'link' => ['type' => 'input', 'status' => false, 'validate' => false],
							'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
							'default' => ['type' => 'checkbox', 'status' => false, 'validate' => false],
						],
					]
				],
			],
		],
	],

	'timeline' => [
		'member' => [
			'table' => [
				'header' => [
					['title' => 'สมาชิก', 'column' => 'member_id', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => 'สถานที่ปัจจุบัน', 'column' => 'current_place', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => 'สถานที่จะไป', 'column' => 'target_place', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => 'ระยะทาง (กม.)', 'column' => 'distance_km', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => 'ค่าน้ำมัน (บาท)', 'column' => 'oil_price', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => 'วันที่', 'column' => 'created_at', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => 'เช็คอิน', 'column' => 'time', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => 'เช็คเอาท์', 'column' => 'checkout_time', 'orderable' => false, 'class' => '', 'status' => true],
					['title' => 'สถานะ', 'column' => 'status', 'orderable' => false, 'class' => '', 'status' => true],
				],
			'filter' => [
				'member_id' => ['type' => 'select', 'url' => 'admin.member.member.get_list', 'status' => true],
				'period' => ['type' => 'selection_date', 'status' => true],
				'check_in_out_period' => ['type' => 'icon', 'status' => true, 'label' => 'วันที่และเวลาเข้า-ออก', 'class' => 'range-filter', 'icon' => 'fe-calendar', 'start' => 'start_time', 'end' => 'end_time'],
				'distance_km_min' => ['type' => 'number', 'status' => true, 'label' => 'ระยะทางขั้นต่ำ (กม.)', 'placeholder' => 'เช่น 10'],
				'distance_km_max' => ['type' => 'number', 'status' => true, 'label' => 'ระยะทางสูงสุด (กม.)', 'placeholder' => 'เช่น 100'],
				'oil_price_min' => ['type' => 'number', 'status' => true, 'label' => 'ค่าน้ำมันขั้นต่ำ (บาท)', 'placeholder' => 'เช่น 500'],
				'oil_price_max' => ['type' => 'number', 'status' => true, 'label' => 'ค่าน้ำมันสูงสุด (บาท)', 'placeholder' => 'เช่น 5000'],
			],
				'btn' => [
					'add' => false,
					'sort' => false,
					'default' => false,
					'status' => false,
					'edit' => true,
					'delete' => false,
					'export' => true,
					'excel' => true,
					'pdf' => true,
				],
			],
			'form' => [
				'navbar' => [
					'translate' => [
						'status' => true,
						'input' => [
							'location_now' => ['type' => 'input', 'status' => false, 'validate' => true],
							'location_to' => ['type' => 'input', 'status' => false, 'validate' => true],
							'distance' => ['type' => 'input', 'status' => true, 'validate' => false],
							'oil_cost' => ['type' => 'input', 'status' => true, 'validate' => true],
							'date' => ['type' => 'input', 'status' => true, 'validate' => true],
							'check_in' => ['type' => 'input', 'status' => true, 'validate' => true],
							'check_out' => ['type' => 'input', 'status' => true, 'validate' => true],
							'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
							'member_id' => ['type' => 'select', 'status' => true, 'validate' => true, 'url' => 'admin.member.get_list', 'label' => __('field.member')],
						],
					],
					'other' => [
						'status' => false,
						'input' => [
							'categories' => ['type' => 'multiple', 'status' => false, 'validate' => false, 'url' => 'admin.products.content.get_category_list', 'max' => 10],
							'related' => ['type' => 'multiple', 'status' => false, 'validate' => false, 'url' => 'admin.products.content.get_list', 'max' => 100],
						],
					],
					'upload' => [
						'status' => false,
						'input' => [
							'gallery' => ['type' => 'gallery', 'status' => false, 'label' => __('field.gallery'), 'max' => '8', 'accept' => 'image/*', 'recommend' => __('field.products.image_recommend')],
							'image' => ['type' => 'upload_image', 'status' => false, 'label' => __('field.image'), 'recommend' => __('field.image_recommend'), 'size' => ''],
							'video' => ['type' => 'upload_video', 'status' => false, 'label' => __('field.video'), 'recommend' => __('field.video_recommend')],
							'youtube' => ['type' => 'input', 'status' => false],
							'file' => ['type' => 'upload_file', 'status' => false, 'label' => __('field.file'), 'recommend' => __('field.file_recommend')],
						],
					],
					'seo' => [
						'status' => false,
					],
				],
				'sidebar' => [
					'lang' => [
						'status' => true,
					],
					'setting' => [
						'status' => true,
						'input' => [
							'categories' => ['type' => 'multiple', 'status' => false, 'validate' => true, 'url' => 'admin.products.category.get_list'],
							'publish_at' => ['type' => 'icon', 'status' => false, 'validate' => false, 'class' => 'datetime-picker', 'icon' => 'fe-calendar'],
							'period' => ['type' => 'icon', 'status' => false, 'validate' => false, 'class' => 'range-picker', 'icon' => 'fe-calendar', 'start' => 'start_at', 'end' => 'end_at'],
							'time' => ['type' => 'time', 'status' => false, 'validate' => false, 'class' => 'time-picker', 'icon' => 'fe-calendar', 'start' => 'start_time', 'end' => 'end_time'],
							'link' => ['type' => 'input', 'status' => false, 'validate' => false],
							'status' => ['type' => 'checkbox', 'status' => true, 'validate' => false],
							'default' => ['type' => 'checkbox', 'status' => false, 'validate' => false],
						],
					]
				],
			],
		],
	],

	// Field validation and form settings
	'field_settings' => [
		// Fields that should remain editable even when record has ID
		'editable_fields' => ['department', 'position'],
		
		// Password fields that should be masked
		'password_fields' => ['password', 'confirm_password'],
		
		// Field types excluded from alphanumeric validation
		'excluded_alphanumeric_types' => ['mail', 'email', 'tel', 'date', 'color', 'text', 'texteditor', 'pass'],
		
		// Fields that allow empty value (optional validation)
		'optional_fields' => ['name'],
		
		// Alphanumeric validation settings
		'alphanumeric' => [
			'pattern' => '[A-Za-z0-9]*',
			'message' => 'กรุณากรอกเฉพาะตัวเลขและตัวอักษร (A-Z, a-z, 0-9)',
		],
		
		// Password mask value
		'password_mask' => '********',
		
		// Default language
		'default_lang' => 'th',
		
		// Script initialization timeout (milliseconds)
		'script_timeout' => 100,
	],
];
