<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Kalnoy\Nestedset\NestedSet;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('member', function (Blueprint $table) {
            $table->id();
            $table->string('type')->nullable();
            $table->string('code')->nullable();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('department')->nullable();
            $table->string('position')->nullable();
            $table->string('password')->nullable();
            $table->string('confirm_password')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('status')->nullable();
            $table->integer('lavel_id')->nullable();
            $table->integer('approve_by_first_id')->nullable();
            $table->integer('approve_by_second_id')->nullable();
            NestedSet::columns($table);
            $table->timestamps();
        });

        // Schema::create('member_lavel', function (Blueprint $table) {
        //     $table->id();
        //     $table->string('type')->nullable();
        //     $table->string('name')->nullable();
        //     $table->integer('status')->nullable();
        //     NestedSet::columns($table);
        //     $table->timestamps();
        // });

        // Schema::create('member_manage', function (Blueprint $table) {
        //     $table->id();
        //     $table->string('type')->nullable();
        //     $table->string('name')->nullable();
        //     $table->integer('status')->nullable();
        //     NestedSet::columns($table);
        //     $table->timestamps();
        // });

        Schema::create('member_timeline', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('member_id')->nullable();
            $table->string('location_now')->nullable();
            $table->string('location_to')->nullable();
            $table->float('distance')->nullable()->comment('ระยะทาง (กม.)');
            $table->float('oil_cost')->nullable()->comment('ค่าน้ำมัน (บาท)');
            $table->date('date')->nullable();
            $table->dateTime('check_in')->nullable();
            $table->dateTime('check_out')->nullable();
            $table->integer('status')->nullable();
            $table->timestamps();
        });

        // Schema::create('member_timeline', function (Blueprint $table) {
        //     $table->id();
        //     $table->unsignedBigInteger('member_id')->nullable();
        //     $table->string('location')->nullable()->comment('สถานที่');
        //     $table->string('location_to')->nullable()->comment('รายละเอียดสถานที่');
        //     $table->string('reason')->nullable()->comment('เหตุผล');
        //     $table->decimal('distance', 8, 2)->nullable()->comment('ระยะทาง (กม.)');
        //     $table->decimal('oil_cost', 10, 2)->nullable()->comment('ค่าน้ำมัน (บาท)');
        //     $table->date('date')->nullable()->comment('วันที่');
        //     $table->time('time')->nullable()->comment('เวลา');
        //     $table->string('status_request')->nullable()->comment('สถานะคำขอ');
        //     $table->integer('status')->default(1);
        //     $table->timestamps();
        //     // Foreign key constraint
        //     $table->foreign('member_id')->references('id')->on('member')->onDelete('cascade');
        // });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('member');
        // Schema::dropIfExists('member_lavel');
        // Schema::dropIfExists('member_timeline');
    }
};
