$(document).ready(function () {
	initDatatable();
	($('[name="style"]').length > 0) && $('[name="style"]').change();
	// mb-2 parent
	checkParent();
	// Hide parent_id input if lavel_id is not selected
	
	if ($('#lavel_id').length > 0 && !$('#lavel_id').val()) {
		$('.parent_id').addClass('d-none');
	}
	
	$("#confirm_password_th").on("change", function() {
		var password = $("#password_th").val();
		if (password != $(this).val()) {
			mwz_noti("error", "รหัสผ่านไม่ตรงกัน");
			$("#password_th").val('');
			$("#confirm_password_th").val('');
			$("#submit").prop('disabled', true);
		} else {
			$("#submit").prop('disabled', false);
		}
	});

})

window.checkParent = function () {
	var lavel = $('[name="lavel_id"]').val();
	Dt_checkParent(lavel);

	$('[name="lavel_id"]').change(function () {
		Dt_checkParent($(this).val());
	});
}

window.Dt_checkParent = function (lavel) {
	if (lavel == 1) {
		$('.parent_id').addClass('d-none');
		$('.approve_by_first').addClass('d-none');
		$('.approve_by_second').addClass('d-none');
	} else {
		$('.parent_id').removeClass('d-none');
		$('.approve_by_first').removeClass('d-none');
		$('.approve_by_second').removeClass('d-none');
	}
}

window.initDatatable = function () {

	if ($(`#${$_name}-datatable`).length > 0) {
		let column = [{ data: "DT_RowIndex", className: 'text-center' }];

		$_config.table.header.forEach((e) => {
			if (e.status)
				column.push({ data: e.column, orderable: e.orderable, className: e.class ?? '' });
		});
		($_config.table.btn.sort) && column.push({ data: "sort", orderable: false, className: 'text-center' });
		column.push(
			{ data: "updated_at", orderable: true },
			{ data: "action", orderable: false, className: 'text-center' }
		);

		let cfg = {
			processing: true,
			serverSide: true,
			stateSave: true,
			columnDefs: [
				{ orderable: true, className: "reorder", targets: 0 },
				{ orderable: false, targets: "_all" },
			],
			ajax: {
				url: $_link_datatable,
				data: function (d) {
					($('.frm-filter').length > 0) && $(".frm-filter").serializeArray().map(function (x) {
						(x.name != '_token') && (d[x.name] = x.value);
					});
				}
			},
			columns: column,
			language: $_LANG.datatable,
		};

		const oTable = $(`#${$_name}-datatable`).DataTable(cfg);
		init_Table();
	}
}


window.setReloadDataTable = function (bool = false) {
	($(`#${$_name}-datatable`).length > 0) && $(`#${$_name}-datatable`).DataTable().ajax.reload(null, bool);
}

window.setSort = function (id, move) {
	event.preventDefault();

	if ($_link_sort.length > 0) {
		$.ajax({
			url: $_link_sort,
			type: "POST",
			data: { id: id, move: move },
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		});
	};
};

window.setDefault = function (id) {
	event.preventDefault();

	if ($_link_default.length > 0) {
		$.ajax({
			url: $_link_default,
			type: "POST",
			data: { id: id },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		})
	}
};

window.setStatus = function (id) {
	event.preventDefault();

	if ($_link_status.length > 0) {
		$.ajax({
			url: $_link_status,
			type: "POST",
			data: { id: id },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		})
	}
};

window.setDelete = function (id) {
	event.preventDefault();

	if ($_link_delete.length > 0) {
		$.ajax({
			url: $_link_delete,
			type: "POST",
			data: { id: id, },
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			success: function (resp) {
				mwz_noti("success", resp.msg, setReloadDataTable());

				if (resp.limit)
					$(`#add`).removeClass('d-none');
			},
			error: function (xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		});
	}
};

window.setSendEmail = function (id) {
	event.preventDefault();
	if ($_link_send_email.length > 0) {
		$.ajax({
			url: $_link_send_email.replace(':id', id),
			type: "GET",
			success: function(response) {
				mwz_noti("success", response.msg || "ส่งอีเมลสำเร็จ");
				setReloadDataTable(true);
			},
			error: function(xhr, status, thrown) {
				ajax_error(xhr, status, thrown);
			}
		});
	}
}

window.setSave = function () {
	event.preventDefault();
	tinyMCE.triggerSave();

	if ($_link_save.length > 0) {
		($_config.form.navbar.seo.status) && mwzGenerateMatadata(0);
		$(`#submit`).prop('disabled', true);
		const frm = $(`#${$_name}_frm`);
		const frm_data = new FormData($(frm)[0]);

		$.ajax({
			url: $_link_save,
			type: "POST",
			data: frm_data,
			contentType: false,
			processData: false,
			headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			beforeSend: function (xhr) {
				let rules = [], msg = [];

				if ($_config.form.navbar.translate.status) {
					$.each($_lang, function (i, lang) {
						$.each($_config.form.navbar.translate.input, function (k, e) {
							let rule = { required: e.validate && e.status };
							// รหัสพนักงาน (code) max 100, ฟิลด์อื่น max 255
							if (k === 'code') {
								rule.maxlength = 100;
							} else {
								rule.maxlength = 255;
							}
							// ถ้าเป็น email ให้เช็ค format ด้วย
							if (k === 'email') {
								rule.email = true;
							}
							rules[`${k}_${lang}`] = rule;
							msg[`${k}_${lang}`] = { 
								required: $(frm).find(`[name="${k}_${lang}"]`).attr('placeholder'),
								email: "รูปแบบอีเมลไม่ถูกต้อง", // เพิ่มข้อความสำหรับ email format error
								maxlength: k === 'code' ? "รหัสพนักงานต้องไม่เกิน 100 ตัวอักษร" : "ต้องไม่เกิน 255 ตัวอักษร"
							};
						});
					});
				}
				if ($_config.form.navbar.other.status) {
					$.each($_config.form.navbar.other.input, function (k, e) {
						rules[`${k}`] = { required: e.status && e.validate };
						msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
					});
				}
				if ($_config.form.sidebar.setting.status) {
					$.each($_config.form.sidebar.setting.input, function (k, e) {
						rules[`${k}`] = { required: e.status && e.validate };
						msg[`${k}`] = { required: $(frm).find(`[name="${k}"]`).attr('placeholder') };
					});
				}

				mwz_validate($(frm), rules, msg);

				if (!frm_valid($(frm))) {
					$(`#submit`).prop('disabled', false);
					return false;
				}

				return true;
			},
			success: function (resp) {
				$(frm).find("#id").val(resp.id);
				($_config.form.navbar.upload.status && $_config.form.navbar.upload.input.gallery.status && $('#gallery').length > 0) ? mwz_multi_upload_process(MULTI_UPLOAD["gallery"], resp) : save_return(resp)
			},
			error: function (xhr, status, thrown) {
				$(`#submit`).prop('disabled', false);
				ajax_error(xhr, status, thrown);
			}
		});
	}
};

window.multiFileUploadCallBack = function (file, resp) {
	save_return(resp);
}

window.save_return = function (resp) {
	mwz_noti("success", resp.msg, window.location.replace(resp.url));
}

window.$('[name="style"]').change(function (e) {
	e.preventDefault();
	const id = $(this).val();

	($('.link').length > 0) && $('.link')[id == 1 ? 'fadeIn' : 'fadeOut']();
	if ($('.tab-style').length > 0) {
		$('.tab-style').removeClass('active');
		$('.tab-style').each(function () {
			console.log($(this).data('id'));
			($(this).data('id') == id) && $(this).addClass('active');
		})
	}

	init_card();
});

/**
 * Export members - Show format selection modal
 */
window.exportMember = function () {
	$('#exportModal').modal('show');
};

/**
 * Select export format and download
 */
window.selectExportFormat = function (format) {
	// Add visual feedback
	$('.export-option').css('border', '2px solid transparent');
	event.currentTarget.style.border = '2px solid #0d6efd';
	
	// Close modal and trigger download
	setTimeout(function() {
		$('#exportModal').modal('hide');
		
		// Build export URL with format parameter
		const exportUrl = $_link_export + '?format=' + format;
		window.location.href = exportUrl;
	}, 300);
};

/**
 * Import members from Excel/CSV
 */
window.importMember = function () {
	$('#importModal').modal('show');
};

/**
 * Download import template
 */
window.downloadTemplate = function () {
	window.location.href = $_link_download_template;
};

/**
 * Handle import file upload
 */
window.handleImportUpload = function () {
	const fileInput = document.getElementById('importFile');
	const file = fileInput.files[0];

	console.log('Import function called');
	console.log('File:', file);

	if (!file) {
		mwz_noti('error', 'กรุณาเลือกไฟล์');
		return;
	}

	// Check file extension
	const validExtensions = ['xlsx', 'xls', 'csv'];
	const fileName = file.name;
	const fileExtension = fileName.split('.').pop().toLowerCase();

	console.log('File extension:', fileExtension);

	if (!validExtensions.includes(fileExtension)) {
		mwz_noti('error', 'รองรับเฉพาะไฟล์ .xlsx, .xls และ .csv เท่านั้น');
		return;
	}

	// Check file size (max 10MB)
	if (file.size > 10 * 1024 * 1024) {
		mwz_noti('error', 'ขนาดไฟล์ต้องไม่เกิน 10MB');
		return;
	}

	const formData = new FormData();
	formData.append('file', file);

	console.log('Import URL:', $_link_import);

	$('#importBtn').prop('disabled', true).html('<i class="mdi mdi-loading mdi-spin"></i> กำลังนำเข้า...');

	$.ajax({
		url: $_link_import,
		type: 'POST',
		data: formData,
		contentType: false,
		processData: false,
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		success: function (resp) {
			console.log('Import success response:', resp);
			
			$('#importModal').modal('hide');
			$('#importFile').val('');
			$('#importBtn').prop('disabled', false).html('<i class="mdi mdi-file-import-outline"></i> นำเข้าข้อมูล');

			let message = resp.msg;
			if (resp.errors && resp.errors.length > 0) {
				message += '<br><br><span style="color: #dc3545; font-weight: bold;">ข้อผิดพลาด:</span><br>';
				resp.errors.forEach(function (error) {
					message += `<span style="color: #dc3545;">แถว ${error.row}: ${error.message}</span><br>`;
				});
			}

			// Reload datatable first
			setReloadDataTable();
			
			// Then show notification
			mwz_noti('success', message);
		},
		error: function (xhr, status, thrown) {
			console.log('Import error:', xhr, status, thrown);
			console.log('Response:', xhr.responseJSON);
			
			$('#importBtn').prop('disabled', false).html('<i class="mdi mdi-file-import-outline"></i> นำเข้าข้อมูล');
			ajax_error(xhr, status, thrown);
		}
	});

	// Initialize field validations
	initFieldValidations();
};	

/**
 * Toggle password visibility
 */
window.togglePasswordVisibility = function(id, btn) {
	const input = document.getElementById(id);
	if (!input) return;
	if (input.type === "password") {
		input.type = "text";
		btn.querySelector('i').classList.remove('fe-eye');
		btn.querySelector('i').classList.add('fe-eye-off');
	} else {
		input.type = "password";
		btn.querySelector('i').classList.remove('fe-eye-off');
		btn.querySelector('i').classList.add('fe-eye');
	}
};

/**
 * Initialize field validations for alphanumeric inputs
 */
window.initFieldValidations = function() {
	// Get config values from data attributes or use defaults
	const alphanumericPattern = document.body.getAttribute('data-alphanumeric-pattern') || '[A-Za-z0-9]*';
	const alphanumericMessage = document.body.getAttribute('data-alphanumeric-message') || 'กรุณากรอกเฉพาะตัวเลขและตัวอักษร (A-Z, a-z, 0-9)';
	const scriptTimeout = parseInt(document.body.getAttribute('data-script-timeout')) || 100;

	// Find all inputs that need alphanumeric validation
	const alphanumericInputs = document.querySelectorAll('[data-alphanumeric="true"]');
	
	alphanumericInputs.forEach(function(input) {
		setTimeout(function() {
			if (input && input.type === 'text' && !input.readOnly && !input.classList.contains('date-picker')) {
				// Add pattern attribute for HTML5 validation
				input.setAttribute('pattern', alphanumericPattern);
				input.setAttribute('title', alphanumericMessage);
				
				// Filter function to keep only alphanumeric characters
				function filterAlphanumeric(value) {
					return value.replace(/[^A-Za-z0-9]/g, '');
				}
				
				// Handle input event
				input.addEventListener('input', function(e) {
					const originalValue = e.target.value;
					const filteredValue = filterAlphanumeric(originalValue);
					
					if (originalValue !== filteredValue) {
						const cursorPos = Math.max(0, e.target.selectionStart - (originalValue.length - filteredValue.length));
						e.target.value = filteredValue;
						e.target.setSelectionRange(cursorPos, cursorPos);
					}
				});
				
				// Handle paste event
				input.addEventListener('paste', function(e) {
					e.preventDefault();
					const pastedText = (e.clipboardData || window.clipboardData).getData('text');
					const filteredText = filterAlphanumeric(pastedText);
					
					if (filteredText) {
						const start = input.selectionStart || 0;
						const end = input.selectionEnd || 0;
						const currentValue = input.value;
						
						input.value = currentValue.substring(0, start) + filteredText + currentValue.substring(end);
						const newCursorPos = start + filteredText.length;
						input.setSelectionRange(newCursorPos, newCursorPos);
						
						// Trigger input event to ensure validation
						input.dispatchEvent(new Event('input', { bubbles: true }));
					}
				});
				
				// Handle keypress to prevent special characters
				input.addEventListener('keypress', function(e) {
					const char = String.fromCharCode(e.which || e.keyCode);
					// Allow only letters and numbers
					if (!/^[A-Za-z0-9]$/.test(char)) {
						e.preventDefault();
						return false;
					}
				});
			}
		}, scriptTimeout);
	});
};