<!DOCTYPE html>
<html lang="th">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>รายชื่อสมาชิก</title>
    <style>
        @font-face {
            font-family: 'THSarabunNew';
            font-style: normal;
            font-weight: normal;
            src: url('{{ storage_path('fonts/THSarabunNew.ttf') }}') format('truetype');
        }
        @font-face {
            font-family: 'THSarabunNew';
            font-style: normal;
            font-weight: bold;
            src: url('{{ storage_path('fonts/THSarabunNew Bold.ttf') }}') format('truetype');
        }
        body {
            font-family: 'THSarabunNew', sans-serif;
            font-size: 16pt;
        }
        h1 {
            text-align: center;
            font-size: 24pt;
            font-weight: bold;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .text-center {
            text-align: center;
        }
        .info {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <h1>รายชื่อสมาชิก</h1>
    
    <div class="info">
        <strong>วันที่ออกรายงาน:</strong> {{ date('d/m/Y H:i:s') }}<br>
        <strong>จำนวนสมาชิกทั้งหมด:</strong> {{ count($members) }} คน
    </div>

    <table>
        <thead>
            <tr>
                <th class="text-center" width="5%">ลำดับ</th>
                <th width="20%">ชื่อ</th>
                <th width="20%">อีเมล</th>
                <th width="18%">แผนก</th>
                <th width="17%">ตำแหน่ง</th>
                <th class="text-center" width="10%">สถานะ</th>
                <th class="text-center" width="10%">วันที่สร้าง</th>
            </tr>
        </thead>
        <tbody>
            @foreach($members as $index => $member)
            <tr>
                <td class="text-center">{{ $index + 1 }}</td>
                <td>{{ $member->name ?? '-' }}</td>
                <td>{{ $member->email ?? '-' }}</td>
                <td>{{ $member->department ?? '-' }}</td>
                <td>{{ $member->position ?? '-' }}</td>
                <td class="text-center">{{ $member->status ? 'ใช้งาน' : 'ไม่ใช้งาน' }}</td>
                <td class="text-center">{{ $member->created_at ? $member->created_at->format('d/m/Y') : '-' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>

