<!DOCTYPE html>
<html lang="th">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>รายงาน Timeline การเดินทาง</title>
    <style>
        /* Embed Thai font (Noto Sans Thai) from storage/fonts for DomPDF */
        @font-face {
            font-family: 'NotoSansThai';
            font-style: normal;
            font-weight: normal;
            src: url('{{ storage_path('fonts/NotoSansThai-Regular.ttf') }}') format('truetype');
        }
        @font-face {
            font-family: 'NotoSansThai';
            font-style: normal;
            font-weight: bold;
            src: url('{{ storage_path('fonts/NotoSansThai-Bold.ttf') }}') format('truetype');
        }
        body {
            font-family: 'NotoSansThai', sans-serif;
            font-size: 12pt;
        }
        h1 {
            text-align: center;
            font-size: 18pt;
            font-weight: bold;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #000;
            padding: 6px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
            font-size: 13pt;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .info {
            margin-bottom: 20px;
        }
        .summary {
            margin-top: 30px;
            padding: 15px;
            background-color: #f9f9f9;
            border: 1px solid #ddd;
        }
        .summary-row {
            display: inline-block;
            width: 48%;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <h1>รายงาน Timeline การเดินทาง</h1>
    
    <div class="info">
        <strong>วันที่ออกรายงาน:</strong> {{ date('d/m/Y H:i:s') }}<br>
        <strong>จำนวนรายการทั้งหมด:</strong> {{ count($timelines) }} รายการ
    </div>

    <table>
        <thead>
            <tr>
                <th class="text-center" width="5%">ลำดับ</th>
                <th width="12%">สมาชิก</th>
                <th width="15%">สถานที่ปัจจุบัน</th>
                <th width="15%">สถานที่จะไป</th>
                <th class="text-center" width="8%">ระยะทาง (กม.)</th>
                <th class="text-center" width="9%">ค่าน้ำมัน (บาท)</th>
                <th class="text-center" width="10%">วันที่</th>
                <th class="text-center" width="8%">เช็คอิน</th>
                <th class="text-center" width="8%">เช็คเอาท์</th>
                <th class="text-center" width="10%">สถานะ</th>
            </tr>
        </thead>
        <tbody>
            @php
                $totalDistance = 0;
                $totalOilCost = 0;
            @endphp
            @foreach($timelines as $index => $timeline)
            @php
                $totalDistance += $timeline->distance ?? 0;
                $totalOilCost += $timeline->oil_cost ?? 0;
            @endphp
            <tr>
                <td class="text-center">{{ $index + 1 }}</td>
                <td>{{ $timeline->member->name ?? '-' }}</td>
                <td>{{ $timeline->current_place ?? '-' }}</td>
                <td>{{ $timeline->target_place ?? '-' }}</td>
                <td class="text-center">{{ $timeline->distance ? number_format($timeline->distance, 2) : '-' }}</td>
                <td class="text-right">{{ $timeline->oil_cost ? number_format($timeline->oil_cost, 2) : '-' }}</td>
                <td class="text-center">{{ $timeline->date ? date('d/m/Y', strtotime($timeline->date)) : '-' }}</td>
                <td class="text-center">{{ $timeline->time ? date('H:i', strtotime($timeline->time)) : '-' }}</td>
                <td class="text-center">{{ $timeline->checkout_time ? date('H:i', strtotime($timeline->checkout_time)) : '-' }}</td>
                <td class="text-center">{{ $timeline->status_request ? $timeline->status_request : '-' }}</td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <th colspan="4" class="text-right">รวมทั้งหมด:</th>
                <th class="text-center">{{ number_format($totalDistance, 2) }}</th>
                <th class="text-right">{{ number_format($totalOilCost, 2) }}</th>
                <th colspan="4"></th>
            </tr>
        </tfoot>
    </table>

    <div class="summary">
        <strong style="font-size: 16pt;">สรุปข้อมูล</strong><br><br>
        <div class="summary-row">
            <strong>ระยะทางรวม:</strong> {{ number_format($totalDistance, 2) }} กิโลเมตร
        </div>
        <div class="summary-row" style="float: right;">
            <strong>ค่าน้ำมันรวม:</strong> {{ number_format($totalOilCost, 2) }} บาท
        </div>
    </div>
</body>
</html>

