@php
    $style = $config['form']['navbar']['style']['input'];
    $data_id = 0;
@endphp
<div class="card card-body">
    @foreach ($style as $k_b => $b)
        @if (empty($b['status']))
            @continue
        @endif
        <div class="tab-style my-1" data-id="{{ ++$data_id }}">
            @if (str_contains($k_b, 'row_'))
                <div class="row">
                    @foreach ($b as $k_i => $i)
                        @if (empty($i['status']))
                            @continue
                        @endif
                        <div class="my-1 col-lg">
                            @if (str_contains($i['type'], 'upload'))
                                <x-upload.image id="{{ $k_i }}" name="{{ $k_i }}" type="{{ explode('_', $i['type'])[1] }}" image="{{ $data->{$k_i} ?? null }}" size="{{ $i['size'] }}" label="{{ $i['label'] }}" recommend="{{ $i['recommend'] }}" />
                            @endif
                        </div>
                    @endforeach
                </div>
            @elseif ($b['type'] == 'input')
                <x-form.input name="{{ $k_b }}" type="{{ $b['type'] }}" value="{{ $data->{$k_b} ?? null }}" label='{{ __("field.{$k_b}") }}' placeholder='{{ __("field.{$k_b}_placeholder") }}' />
            @elseif ($b['type'] == 'upload_video')
                <x-upload.image id="{{ $k_b }}" name="{{ $k_b }}" type="{{ explode('_', $b['type'])[1] }}" image="{{ $data->{$k_b} ?? null }}" label="{{ $b['label'] }}" recommend="{{ $b['recommend'] }}" />
            @elseif ($b['type'] == 'upload_file')
                <x-upload.image id="{{ $k_b }}" name="{{ $k_b }}" type="{{ explode('_', $b['type'])[1] }}" image="{{ $data->{$k_b} ?? null }}" label="{{ $b['label'] }}" recommend="{{ $b['recommend'] }}" />
            @endif
        </div>
    @endforeach
</div>
