@php
    $nav = $tab = -1;
    $upload = $config['form']['navbar']['upload']['input'];
@endphp
<div class="card card-body p-0">
    <ul class="nav nav-tabs nav-bordered">
        @foreach ($upload as $k_u => $u)
            @if (!empty($u['status']))
                <li class="nav-item">
                    <a class="nav-link {{ ++$nav == 0 ? 'active' : '' }}" data-bs-toggle="tab" href="#{{ $k_u }}" aria-expanded="false">
                        {{ !empty($u['label']) ? $u['label'] : __("field.{$k_u}") }}
                    </a>
                </li>
            @endif
        @endforeach
    </ul>
    <div class="tab-content p-3">
        @foreach ($upload as $k_u => $u)
            @if (!empty($u['status']))
                <div class="tab-pane {{ ++$tab == 0 ? 'active' : '' }}" id="{{ $k_u }}">
                    @if (str_contains($u['type'], 'upload'))
                        @php
                            $t = str_replace('upload_', '', $u['type']);
                        @endphp
                        <x-upload.image id="{{ $tab }}" name="{{ $k_u }}" type="{{ $t }}" label="{{ $u['label'] }}" image="{{ $data->{$k_u} ?? null }}" recommend="{{ $u['recommend'] }}" />
                    @elseif ($u['type'] == 'input')
                        <x-form.input name="{{ $k_u }}" type="{{ $u['type'] }}" value="{{ $data->{$k_u} ?? null }}" label="{{ !empty($u['label']) ? $u['label'] : __('field.' . $k_u) }}" placeholder="{{ __('field.' . $k_u . '_placeholder') }}" />
                    @elseif ($u['type'] == 'gallery')
                        @php
                            $gallery = $data->{$k_u} ?? null;
                        @endphp
                        <x-upload.multiple id="{{ $k_u }}" name="{{ $k_u }}" :files=$gallery action='{{ route("admin.{$type}.{$method}.set_gallery") }}' accept="{{ !empty($u['accept']) ? $u['accept'] : 'image/*' }}" max="{{ !empty($u['max']) ? $u['max'] : 10 }}" recommend="{{ $u['recommend'] ?? '' }}" />
                    @endif
                </div>
            @endif
        @endforeach
    </div>
</div>
