@extends('form.app')

@section('styles')
    <link href="{{ asset('assets/libs/dropzone/dropzone.min.css') }}" rel="stylesheet" />
@endsection

@section('content')
    {{-- navbar --}}
    {{-- @includeIf('member::form.navbar') --}}
    <form class="row" id="{{ $method }}_frm" method="POST" enctype="multipart/form-data">
        @csrf
        <input id="id" name="id" type="hidden" value="{{ $data->id ?? '0' }}">
        <div class="col-lg-9">
            <div class="tab-content">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title mb-4">
                            การตั้งค่าการลบข้อมูล Timeline
                        </h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="months" class="form-label text-muted fw-bold">เลือกระยะเวลาเก็บข้อมูล (เดือน)</label>
                                <select id="months" class="form-select">
                                    @for($m=1;$m<=12;$m++)
                                        <option value="{{ $m }}">{{ $m }} เดือน</option>
                                    @endfor
                                </select>
                            </div>
                            <div class="col-12">
                                <button type="button" id="btn-clear-timeline" class="btn btn-danger mt-2">
                                    ลบข้อมูลที่เก่ากว่า ระยะเวลาที่เลือก
                                </button>
                                <small class="text-muted d-block mt-2">ระบบจะลบข้อมูล timeline ที่เก่ากว่า N เดือนจากวันนี้</small>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-body">
                        <h5 class="card-title mb-4">การตั้งค่า รันรหัสพนักงาน</h5>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label text-muted fw-bold">Prefix</label>
                                <input type="text" id="code_prefix" class="form-control" value="EMP">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label text-muted fw-bold">จำนวนหลัก (Padding)</label>
                                <select id="code_padding" class="form-select">
                                    @for($p=3;$p<=8;$p++)
                                        <option value="{{ $p }}">{{ $p }}</option>
                                    @endfor
                                </select>
                            </div>
                            <div class="col-12">
                                <button type="button" id="btn-run-code" class="btn btn-primary mt-2">รันรหัสพนักงานใหม่</button>
                                <small class="text-muted d-block mt-2">ระบบจะกำหนดรหัสแบบ Prefix + เลขเรียง เช่น EMP00001</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            {{-- แสดงข้อมูล  --}}
            {{-- @include('member::timeline.detail') --}}
        </div>
    </form>
@endsection

@section('scripts')
    <!-- File uploads multiple js -->
    <script src="{{ asset('assets/libs/dropzone/dropzone.min.js') }}"></script>
    <script type="text/javascript">
        Dropzone.autoDiscover = false;
    </script>

    <!-- Jquery UI-->
    <script src="{{ asset('assets/libs/jquery-ui/jquery-ui.min.js') }}"></script>

    <script>
        const $_name = '<?= $method ?>';
        const $_type = '<?= $type ?>';
        const $_config = $.parseJSON('<?= json_encode($config) ?>');

        // link action
        const $_link_save = '{{ route("admin.{$type}.{$method}.save") }}';
        const $_link_clear = '{{ route("admin.member.timeline.clear") }}';
        const $_link_run_code = '{{ route("admin.member.setting.run_code") }}';

        // persist selected months in localStorage
        const monthsKey = 'member_timeline_clear_months';
        const savedMonths = localStorage.getItem(monthsKey);
        if(savedMonths){
            $('#months').val(savedMonths);
        }
        $(document).on('change', '#months', function(){
            localStorage.setItem(monthsKey, $(this).val());
        });

        $(document).on('click', '#btn-clear-timeline', function(){
            const months = $('#months').val();
            if(!months) return;
            Swal.fire({
                title: 'ยืนยันการลบข้อมูล?',
                text: 'จะลบข้อมูล timeline ที่เก่ากว่า ' + months + ' เดือน',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'ยืนยัน',
                cancelButtonText: 'ยกเลิก'
            }).then((result) => {
                if(result.isConfirmed){
                    $.post($_link_clear, { months: months, _token: $('meta[name="csrf-token"]').attr('content') })
                        .done(function(resp){
                            Swal.fire('สำเร็จ', resp.msg + ' ลบออก ' + (resp.deleted ?? 0) + ' รายการ', 'success');
                        })
                        .fail(function(xhr){
                            Swal.fire('ผิดพลาด', xhr.responseJSON?.msg || 'เกิดข้อผิดพลาด', 'error');
                        });
                }
            });
        });

        $(document).on('click', '#btn-run-code', function(){
            const prefix = $('#code_prefix').val() || 'EMP';
            const padding = $('#code_padding').val() || 5;
            Swal.fire({
                title: 'รันรหัสพนักงานใหม่?',
                html: 'รูปแบบตัวอย่าง: <b>' + prefix + String('0'.repeat(padding - 1)) + '1</b>',
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'ยืนยัน',
                cancelButtonText: 'ยกเลิก'
            }).then((result) => {
                if(result.isConfirmed){
                    $.post($_link_run_code, { prefix: prefix, padding: padding, _token: $('meta[name="csrf-token"]').attr('content') })
                        .done(function(resp){
                            Swal.fire('สำเร็จ', resp.msg + ' อัปเดตรหัส: ' + (resp.updated ?? 0) + ' รายการ', 'success');
                        })
                        .fail(function(xhr){
                            Swal.fire('ผิดพลาด', xhr.responseJSON?.msg || 'เกิดข้อผิดพลาด', 'error');
                        });
                }
            });
        });
    </script>

    {{ module_vite("build-member", "resources/assets/js/{$method}.js") }}
@endsection
