<div class="row">
    @if (!empty($config['table']['filter']))
        @foreach ($config['table']['filter'] as $k_f => $f)
            @if (!empty($f['status']))
                <div class="my-2 col-lg-3 col-md-6">
                    @if ($f['type'] == 'selection_date')
                        <x-select2.selection class="frm-filter" id="{{ $k_f }}" name="filter[{{ $k_f }}]" label='{{ $f["label"] ?? __("filter.date") }}'>
                            @slot('option')
                                <option value="00">{{ __('filter.all') }}</option>
                                <option value="1">{{ __('filter.today') }}</option>
                                <option value="2">{{ __('filter.yesterday') }}</option>
                                <option value="3">{{ __('filter.last_7_days') }}</option>
                                <option value="4">{{ __('filter.last_30_days') }}</option>
                                <option value="5">{{ __('filter.this_month') }}</option>
                                <option value="6">{{ __('filter.last_month') }}</option>
                                <option value="7">{{ __('filter.custom') }}</option>
                            @endslot
                        </x-select2.selection>
                        <div class="input-group mt-3 date-range-{{ $k_f }}" style="display: none;">
                            <span class="input-group-text"><i class="mdi mdi-calendar-month"></i></span>
                            <input class="form-control range-filter frm-filter" id="range-{{ $k_f }}" name="filter[range_{{ $k_f }}]" type="text" placeholder="{{ __('filter.range') }}">
                        </div>
                    @elseif ($f['type'] == 'select')
                        <x-select2.select class="frm-filter" id="{{ $k_f }}" name="filter[{{ $k_f }}]" label='{{ $f["label"] ?? __("field.{$k_f}") }}' url="{{ route($f['url']) }}" :selected="$selectedMember ?? null"
                        :map="true" />
                        <input type="hidden" name="filter[{{ $k_f }}]" value="{{ $selectedMember->member_id ?? '' }}" >
                    @elseif ($f['type'] == 'number')
                        <label class="form-label">{{ $f['label'] ?? __("field.{$k_f}") }}</label>
                        <input type="number" class="form-control frm-filter" id="{{ $k_f }}" name="filter[{{ $k_f }}]" placeholder="{{ $f['placeholder'] ?? '' }}" step="0.01">
                    @elseif ($f['type'] == 'icon')
                        <label class="form-label">{{ $f['label'] ?? __("field.{$k_f}") }}</label>
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="{{ $f['icon'] ?? '' }}"></i>
                            </span>
                            <input class="form-control frm-filter {{ $f['class'] ?? '' }}" id="{{ $k_f }}" name="filter[{{ $k_f }}]" type="text" placeholder="{{ __('filter.range') }}">
                        </div>
                    @endif
                </div>
            @endif
        @endforeach
    @endif
</div>
