<?php

use Illuminate\Support\Facades\Route;
use Modules\Member\app\Http\Controllers\MemberAdminController;
use Modules\Member\app\Http\Controllers\MemberController;
use Modules\Member\app\Http\Controllers\MemberlavelAdminController;
use Modules\Member\app\Http\Controllers\MemberManageAdminController;
use Modules\Member\app\Http\Controllers\MemberSettingAdminController;
use Modules\Member\app\Http\Controllers\TimelineAdminController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::middleware(['auth:admin', 'adminAccessControl'])->prefix('admin')->name('admin.')->group(function () {
	// ['method', 'url', 'controller', 'name']
	$default_route_member = [
		['get', '/', 'index', 'index'],
		['get', '/datatable_ajax', 'datatable_ajax', 'datatable_ajax'],
		['get', '/add', 'form', 'add'],
		['get', '/edit/{id?}', 'form', 'edit'],
		['get', '/view/{member_id?}', 'index', 'view'],
		['post', '/save', 'save', 'save'],
		['post', '/set-sort', 'set_sort', 'set_sort'],
		['post', '/set-default', 'set_default', 'set_default'],
		['post', '/set-status', 'set_status', 'set_status'],
		['post', '/set-delete', 'set_delete', 'set_delete'],
		['post', '/get-list', 'get_list', 'get_list'],
		['get', '/export', 'export', 'export'],
		['post', '/import', 'import', 'import'],
		['get', '/download-template', 'download_template', 'download_template'],
		['get', '/send-email/{id}', 'send_email', 'send_email'],
	];
	$default_route_lavel = [
		['get', '/', 'index', 'index'],
		['get', '/datatable_ajax', 'datatable_ajax', 'datatable_ajax'],
		['get', '/add', 'form', 'add'],
		['get', '/edit/{id}', 'form', 'edit'],
		['get', '/view/{id}', 'form', 'view'],
		['post', '/save', 'save', 'save'],
		['post', '/set-sort', 'set_sort', 'set_sort'],
		['post', '/set-default', 'set_default', 'set_default'],
		['post', '/set-status', 'set_status', 'set_status'],
		['post', '/set-delete', 'set_delete', 'set_delete'],
		['post', '/get-list', 'get_list', 'get_list'],
		['post', '/save-gallery', 'save_gallery', 'set_gallery'],
	];

	$default_route_manage = [
		['get', '/', 'index', 'index'],
		['get', '/datatable_ajax', 'datatable_ajax', 'datatable_ajax'],
		['get', '/add', 'form', 'add'],
		['get', '/edit/{id}', 'form', 'edit'],
		['get', '/view/{id}', 'form', 'view'],
		['post', '/save', 'save', 'save'],
		['post', '/set-sort', 'set_sort', 'set_sort'],
		['post', '/set-default', 'set_default', 'set_default'],
		['post', '/set-status', 'set_status', 'set_status'],
		['post', '/set-delete', 'set_delete', 'set_delete'],
		['post', '/get-list', 'get_list', 'get_list'],
	];
	Route::prefix('member')->name('member.')->group(function () use ($default_route_member,$default_route_lavel,$default_route_manage) {
		Route::prefix('member')->name('member.')->group(function () use ($default_route_member) {
			foreach ($default_route_member as $route)
				Route::{$route[0]}($route[1], [MemberAdminController::class, $route[2]])->name($route[3]);
		});
		Route::prefix('lavel')->name('lavel.')->group(function () use ($default_route_lavel) {
			foreach ($default_route_lavel as $route)
				Route::{$route[0]}($route[1], [MemberlavelAdminController::class, $route[2]])->name($route[3]);
		});
		Route::prefix('manage')->name('manage.')->group(function () use ($default_route_manage) {
			foreach ($default_route_manage as $route)
				Route::{$route[0]}($route[1], [MemberManageAdminController::class, $route[2]])->name($route[3]);
		});
		Route::prefix('timeline')->name('timeline.')->group(function () use ($default_route_member) {
			foreach ($default_route_member as $route)
				Route::{$route[0]}($route[1], [TimelineAdminController::class, $route[2]])->name($route[3]);
			// clear old timeline records by months
			Route::post('/clear', [TimelineAdminController::class, 'clear'])->name('clear');
		});
		Route::prefix('setting')->name('setting.')->group(function () use ($default_route_member) {
			foreach ($default_route_member as $route)
				Route::{$route[0]}($route[1], [MemberSettingAdminController::class, $route[2]])->name($route[3]);
			// run/generate employee codes
			Route::post('/run-code', [MemberSettingAdminController::class, 'run_code'])->name('run_code');
		});
	});
});

Route::middleware(['apiLocale'])->prefix('api/v1')->name('api.')->group(function () {
	Route::prefix('member')->name('member.')->group(function () {
		Route::post('/click', [MemberController::class, 'click'])->name('click');
	});
});
