<?php

namespace Modules\Menu\app\Http\Controllers;

use Modules\Menu\app\Models\Menu;
use Modules\Mwz\app\Http\Controllers\AdminController;
use Modules\Mwz\app\Http\Controllers\SlugController;

class MenuController extends AdminController
{

	/**
	 * Function : menu get menu
	 * Dev : Peh
	 * Update Date : 18 Apr 2024
	 * @param mixed $type
	 * @return array data menu
	 */
	public static function get_menu($opt = []): array
	{
		$data = [];
		$req = Menu::where('status', 1);

		if (!empty($opt['section']))
			$req = $req->where('section', $opt['section']);
		if (!empty($opt['parent_id']))
			$req = $req->whereIn('parent_id', $opt['parent_id']);
		if (!empty($opt['menu_id']))
			$req = $req->where('id', $opt['menu_id']);
		if (!empty($opt['except_id']))
			$req = $req->whereNotIn('id', $opt['except_id']);

		$req = $req->with(['children' => function ($q) {
			return $q->orderBy('_lft');
		}])
			->orderBy('_lft')
			->get();

		if (!empty($req)) {
			foreach ($req as $item)
				$data[] = self::mapping($item);
		}
		return $data;
	}
	
	/**
	 * Function : menu get menu
	 * Dev : Peh
	 * Update Date : 18 Apr 2024
	 * @param mixed $type
	 * @return array data menu
	 */
	public static function menu($group_id = 1): array
	{
		$data = [];
		$req = Menu::where([['parent_id', $group_id], ['status', 1]])
			->orderBy('_lft')
			->with(['local', 'slug', 'child.local', 'child.slug', 'child.child'])
			->get();

		if (!empty($req)) {
			foreach ($req as $item)
				$data[] = self::mapping($item);
		}

		return $data;
	}

	/**
	 * Function : menu route
	 * Dev : Peh
	 * Update Date : 18 Apr 2024
	 * @param int $id
	 * @return array data menu route
	 */
	public static function menu_route($id): array
	{
		$resp = Menu::find($id);
		$data = [];
		if (!empty($resp)) {
			$data = ['id' => $resp->id, 'name' => $resp->local->name, 'status' => $resp->status ?? 0];
			if ($resp->type == 1)
				$data['url'] =  mwz_route('frontend.slug', [$resp->slug->slug ?? '']);
			else
				$data['url'] = $resp->url;
		}

		return $data;
	}

	/**
	 * Function : menu mapping
	 * Dev : Petch
	 * Update Date : 5 March 2025
	 * @param mixed $resp
	 * @return array data menu mapping
	 */
	private static function mapping($resp): array
	{
		$config = config("menu.menu");
		$data = [
			'id' => $resp->id,
		];

		foreach ($config['input'] as $key => $item) {
			if (!empty($item['status']))
				$data[$key] = mwz_getTextString($resp->local->{$key} ?? null, $item['type'] == 'input');
		}

		if ($resp->type == 1)
			$data['url'] = mwz_route('frontend.slug', [$resp->slug->slug ?? '']);
		else
			$data['url'] = $resp->url;

		if (!empty($config['setting']['style']['status']))
			$data['style'] = $resp->style;

		if (!empty($resp->child)) {
			foreach ($resp->child as $c)
				$data['sub'][] = self::mapping($c);
		} elseif (!empty($config['setting']['widget']['status']))
			$data['widget'] = self::widget($resp->widget);

		return $data;
	}

	/**
	 * Function : widget
	 * Dev : Peh
	 * Update Date : 18 Apr 2024
	 * @param string $type
	 * @return mixed data widget
	 */
	private static function widget($type)
	{
		switch ($type) {
			case 'about':
				# code...
				break;
			case 'product_category':
				# code...
				break;
			case 'product':
				// $req = new ContentsController;
				// return  $req->get_list('product', $option = ['recommend' => 1, 'cur_page' => 1, 'per_page' => 6, 'column' => 'sequence', 'dir' => "ASC"])['list'] ?? [];
				break;
			case 'news':
				# code...
				break;
		}
	}
}
